/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts;

import java.beans.PropertyChangeEvent;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.editparts.AbstractEditPart;
import net.sf.amateras.air.mxml.editparts.policy.EntityComponentEditPolicy;
import net.sf.amateras.air.mxml.figures.IFlexRectangleFigure;
import net.sf.amateras.air.mxml.models.AbstractComponentModel;
import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IFileEditorInput;

public abstract class AbstractComponentEditPart
extends AbstractEditPart {
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityComponentEditPolicy());
    }

    protected IProject getProject() {
        DefaultEditDomain domain = (DefaultEditDomain)this.getViewer().getEditDomain();
        IFileEditorInput input = (IFileEditorInput)domain.getEditorPart().getEditorInput();
        return input.getFile().getProject();
    }

    protected IFile getEmbedResource(String property) {
        if (property.startsWith("@Embed(") && property.endsWith("')")) {
            property = property.replaceFirst("^@Embed\\(.*?'", "");
            property = property.replaceFirst("'\\)$", "");
            String filePath = null;
            DefaultEditDomain domain = (DefaultEditDomain)this.getViewer().getEditDomain();
            IFileEditorInput input = (IFileEditorInput)domain.getEditorPart().getEditorInput();
            IFile resource = input.getFile();
            if (resource != null) {
                String folder = resource.getProjectRelativePath().removeLastSegments(1).toString();
                filePath = String.valueOf(folder) + "/" + property;
            } else {
                filePath = property;
            }
            IFile file = this.getProject().getFile((IPath)new Path(filePath));
            if (file != null && file.exists()) {
                return file;
            }
        }
        return null;
    }

    protected Image getEmbedResourceAsImage(String property) {
        IFile file = this.getEmbedResource(property);
        if (file != null) {
            try {
                return new Image(null, file.getContents());
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    protected void refreshVisuals() {
        Object model = this.getModel();
        if (model instanceof IComponentModel) {
            IComponentModel compModel = (IComponentModel)model;
            String strX = compModel.getAttributeToString("x");
            String strY = compModel.getAttributeToString("y");
            String strWidth = compModel.getAttributeToString("width");
            String strHeight = compModel.getAttributeToString("height");
            FlexRectangle constraint = compModel.getConstraint();
            if (constraint == null) {
                constraint = new FlexRectangle();
            }
            constraint.setStrWidth(strWidth);
            constraint.setStrHeight(strHeight);
            constraint.setStrX(strX);
            constraint.setStrY(strY);
            this.refreshLayoutConstraint(constraint);
        }
    }

    protected void refreshLayoutConstraint(FlexRectangle constraint) {
        if (this.getFigure() instanceof IFlexRectangleFigure) {
            ((IFlexRectangleFigure)this.getFigure()).setRectangle(constraint);
        } else {
            this.getFigure().setBounds((Rectangle)constraint);
        }
        if (this.getFigure().getParent() == null) {
            System.err.println("Figure parent is Null.figure=" + this.getFigure());
        } else {
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    protected Color getColor(String propertyName) {
        return this.getColor((RGB)((IModel)this.getModel()).getAttribute(propertyName));
    }

    protected Color getColor(RGB rgb) {
        return AIRPlugin.getDefault().getColorManager().getColor(rgb);
    }

    protected void setTextDecoration(AbstractComponentModel model, Label label) {
        Object align;
        Color color = this.getColor("color");
        if (color != null) {
            label.setForegroundColor(this.getColor("color"));
        }
        if ((align = model.getAttribute("textAlign")) != null) {
            if (align.toString().equals("right")) {
                label.setLabelAlignment(4);
            } else if (align.toString().equals("center")) {
                label.setLabelAlignment(2);
            } else {
                label.setLabelAlignment(1);
            }
        }
    }
}

