/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts;

import java.util.List;
import net.sf.amateras.air.mxml.editparts.AbstractComponentEditPart;
import net.sf.amateras.air.mxml.editparts.policy.ResizeableFlowLayoutEditPolicy;
import net.sf.amateras.air.mxml.figures.AccordionFigure;
import net.sf.amateras.air.mxml.models.AbstractContainerModel;
import net.sf.amateras.air.mxml.models.AccordionModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;

public class AccordionEditPart
extends AbstractComponentEditPart {
    protected IFigure createFigure() {
        AccordionFigure figure = new AccordionFigure();
        this.updateFigure((AccordionModel)this.getModel(), figure);
        return figure;
    }

    protected List getModelChildren() {
        return ((IContainerModel)this.getModel()).getChildren();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ResizeableFlowLayoutEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        AccordionModel model = (AccordionModel)this.getModel();
        AccordionFigure figure = (AccordionFigure)this.getFigure();
        this.updateFigure(model, figure);
    }

    public void refresh() {
        super.refresh();
        AccordionModel model = (AccordionModel)this.getModel();
        AccordionFigure figure = (AccordionFigure)this.getFigure();
        try {
            int index = model.getSelectedIndex();
            if (index < 0) {
                index = model.getAttributeToNumber("selectedIndex");
            }
            figure.setSelectedIndex(index);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        String title = "";
        if (childEditPart.getModel() instanceof AbstractContainerModel) {
            title = ((AbstractContainerModel)childEditPart.getModel()).getAttributeToString("label");
        }
        ((AccordionFigure)this.getFigure()).add(child, title, child.getBounds(), index);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getFigure().remove(child);
    }

    private void updateFigure(AccordionModel model, AccordionFigure figure) {
        figure.setToolTip((IFigure)new Label(model.toString()));
        try {
            int top = model.getAttributeToNumber("paddingTop");
            int left = model.getAttributeToNumber("paddingLeft");
            int right = model.getAttributeToNumber("paddingRight");
            int bottom = model.getAttributeToNumber("paddingBottom");
            figure.setPadding(new Insets(top, left, bottom, right));
        }
        catch (NumberFormatException numberFormatException) {}
        figure.revalidate();
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
    }
}

