/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.editparts.AbstractDirectEditPart;
import net.sf.amateras.air.mxml.figures.Button;
import net.sf.amateras.air.mxml.models.ButtonModel;
import net.sf.amateras.air.util.ColorUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;

public class ButtonEditPart
extends AbstractDirectEditPart {
    private String oldIcon = "";

    protected IFigure createFigure() {
        Button button = new Button();
        this.updateFigure(button, (ButtonModel)this.getModel());
        return button;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.updateFigure((Button)this.getFigure(), (ButtonModel)this.getModel());
    }

    protected void updateFigure(Button button, ButtonModel model) {
        button.setToolTip((IFigure)new Label(model.toString()));
        button.setText(model.getAttributeToString("label"));
        if (!model.getAttributeToString("icon").equals(this.oldIcon)) {
            this.oldIcon = (String)model.getAttribute("icon");
            button.setIcon(this.getEmbedResourceAsImage(this.oldIcon));
        }
        AIRPlugin.getDefault().getFontManager().setFont(model, (IFigure)button);
        if (model.getAttribute("fillColors") != null) {
            String value = model.getAttributeToString("fillColors");
            if ((value = value.replaceAll("0x", "#")).length() > 0) {
                value = value.substring(1, 8);
                button.setBackgroundColor(this.getColor(ColorUtil.toRGB(value)));
            }
        }
        this.setTextDecoration(model, button);
        try {
            int top = model.getAttributeToNumber("paddingTop");
            int left = model.getAttributeToNumber("paddingLeft");
            int right = model.getAttributeToNumber("paddingRight");
            int bottom = model.getAttributeToNumber("paddingBottom");
            button.setPadding(new Insets(top, left, bottom, right));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected String getDirectEditPropertyKey() {
        return "label";
    }
}

