/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts;

import java.util.List;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.editparts.AbstractComponentEditPart;
import net.sf.amateras.air.mxml.editparts.policy.RootEditPolicy;
import net.sf.amateras.air.mxml.figures.ContainerFigure;
import net.sf.amateras.air.mxml.models.CanvasModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.RGB;

public class CanvasEditPart
extends AbstractComponentEditPart {
    protected IFigure createFigure() {
        ContainerFigure figure = new ContainerFigure();
        figure.setOpaque(true);
        figure.setLayout(true);
        this.updateFigure((CanvasModel)this.getModel(), figure);
        return figure;
    }

    protected List getModelChildren() {
        return ((IContainerModel)this.getModel()).getChildren();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new RootEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        CanvasModel model = (CanvasModel)this.getModel();
        ContainerFigure figure = (ContainerFigure)this.getFigure();
        this.updateFigure(model, figure);
    }

    private void updateFigure(CanvasModel model, ContainerFigure figure) {
        figure.setToolTip((IFigure)new Label(model.toString()));
        try {
            int top = model.getAttributeToNumber("paddingTop");
            int left = model.getAttributeToNumber("paddingLeft");
            int right = model.getAttributeToNumber("paddingRight");
            int bottom = model.getAttributeToNumber("paddingBottom");
            figure.setPadding(new Insets(top, left, bottom, right));
        }
        catch (NumberFormatException numberFormatException) {}
        AIRPlugin.getDefault().getFontManager().setFont(model, (IFigure)figure);
        if (model.getAttribute("color") != null) {
            figure.setForegroundColor(this.getColor("color"));
        }
        figure.setBackgroundColor(this.getColor((RGB)model.getAttribute("backgroundColor")));
        figure.revalidate();
    }
}

