/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.editparts.AbstractDirectEditPart;
import net.sf.amateras.air.mxml.figures.DataGridColumnFigure;
import net.sf.amateras.air.mxml.models.DataGridColumnModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;

public class DataGridColumnEditPart
extends AbstractDirectEditPart {
    protected IFigure createFigure() {
        DataGridColumnModel model = (DataGridColumnModel)this.getModel();
        DataGridColumnFigure column = new DataGridColumnFigure();
        column.setWidth(column.getDefaultWidth());
        this.updateFigure(column, model);
        return column;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.updateFigure((DataGridColumnFigure)this.getFigure(), (DataGridColumnModel)this.getModel());
    }

    private void updateFigure(DataGridColumnFigure column, DataGridColumnModel model) {
        Object align;
        column.setText(model.getAttributeToString("headerText"));
        Object swidth = model.getAttribute("width");
        try {
            column.setWidth(Integer.parseInt(swidth.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            column.setWidth(100);
        }
        AIRPlugin.getDefault().getFontManager().setFont(model, (IFigure)column);
        Color color = this.getColor("color");
        if (color != null) {
            column.setHeaderForegroundColor(color);
        }
        if ((align = model.getAttribute("textAlign")) != null) {
            if (align.toString().equals("right")) {
                column.setHeaderLabelAlignment(4);
            } else if (align.toString().equals("center")) {
                column.setHeaderLabelAlignment(2);
            } else {
                column.setHeaderLabelAlignment(1);
            }
        }
        column.revalidate();
    }

    protected String getDirectEditPropertyKey() {
        return "headerText";
    }

    protected IFigure getDirectEditFigure() {
        return ((DataGridColumnFigure)this.getFigure()).getTitleFigure();
    }
}

