/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.editparts.AbstractDirectEditPart;
import net.sf.amateras.air.mxml.figures.LabelFigure;
import net.sf.amateras.air.mxml.models.LinkButtonModel;
import net.sf.amateras.air.util.ColorUtil;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;

public class LinkButtonEditPart
extends AbstractDirectEditPart {
    private String oldIcon = "";

    protected IFigure createFigure() {
        LabelFigure figure = new LabelFigure();
        figure.setLabelAlignment(2);
        figure.setBorder((Border)new LineBorder(ColorConstants.lightGray));
        this.updateFigure(figure, (LinkButtonModel)this.getModel());
        return figure;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.updateFigure((LabelFigure)this.getFigure(), (LinkButtonModel)this.getModel());
    }

    private void updateFigure(LabelFigure figure, LinkButtonModel model) {
        figure.setToolTip((IFigure)new Label(model.toString()));
        figure.setText(model.getAttributeToString("label"));
        if (!model.getAttributeToString("icon").equals(this.oldIcon)) {
            this.oldIcon = (String)model.getAttribute("icon");
            figure.setIcon(this.getEmbedResourceAsImage(this.oldIcon));
        }
        AIRPlugin.getDefault().getFontManager().setFont(model, (IFigure)figure);
        this.setTextDecoration(model, figure);
        if (model.getAttribute("fillColors") != null) {
            String value = model.getAttributeToString("fillColors");
            if ((value = value.replaceAll("0x", "#")).length() > 0) {
                value = value.substring(1, 8);
                figure.setBackgroundColor(this.getColor(ColorUtil.toRGB(value)));
            }
        }
    }

    protected String getDirectEditPropertyKey() {
        return "label";
    }
}

