/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts;

import java.util.List;
import net.sf.amateras.air.mxml.editparts.AbstractComponentEditPart;
import net.sf.amateras.air.mxml.editparts.policy.ResizeableFlowLayoutEditPolicy;
import net.sf.amateras.air.mxml.editparts.policy.RootEditPolicy;
import net.sf.amateras.air.mxml.figures.PanelFigure;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.PanelModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.RGB;

public class PanelEditPart
extends AbstractComponentEditPart {
    protected IFigure createFigure() {
        PanelFigure figure = new PanelFigure();
        this.updateFigure(figure, (PanelModel)this.getModel());
        return figure;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        PanelModel model = (PanelModel)this.getModel();
        PanelFigure figure = (PanelFigure)this.getFigure();
        this.updateFigure(figure, model);
    }

    protected void updateFigure(PanelFigure panel, PanelModel model) {
        panel.setToolTip((IFigure)new Label(model.toString()));
        panel.setBorderColor(this.getColor((RGB)model.getAttribute("borderColor")));
        panel.setTitleColor(this.getColor((RGB)model.getAttribute("color")));
        panel.setTitle(model.getAttributeToString("title"));
        panel.setBackgroundColor(this.getColor((RGB)model.getAttribute("backgroundColor")));
        String direction = (String)model.getAttribute("layout");
        if (direction.equalsIgnoreCase("vertical")) {
            panel.setLayout(false);
            panel.setVertical(true);
            try {
                panel.setSpacing(model.getAttributeToNumber("verticalGap"));
            }
            catch (NumberFormatException numberFormatException) {}
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ResizeableFlowLayoutEditPolicy());
        } else if (direction.equalsIgnoreCase("horizontal")) {
            panel.setLayout(false);
            panel.setVertical(false);
            try {
                panel.setSpacing(model.getAttributeToNumber("horizontalGap"));
            }
            catch (NumberFormatException numberFormatException) {}
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ResizeableFlowLayoutEditPolicy());
        } else {
            panel.setLayout(true);
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new RootEditPolicy());
        }
        try {
            int top = model.getAttributeToNumber("paddingTop");
            int left = model.getAttributeToNumber("paddingLeft");
            int right = model.getAttributeToNumber("paddingRight");
            int bottom = model.getAttributeToNumber("paddingBottom");
            panel.setPadding(new Insets(top, left, bottom, right));
        }
        catch (NumberFormatException numberFormatException) {}
        panel.revalidate();
    }

    protected List getModelChildren() {
        return ((IContainerModel)this.getModel()).getChildren();
    }
}

