/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.editparts.AbstractDirectEditPart;
import net.sf.amateras.air.mxml.figures.TextArea;
import net.sf.amateras.air.mxml.models.TextAreaModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

public class TextAreaEditPart
extends AbstractDirectEditPart {
    protected IFigure createFigure() {
        TextAreaModel model = (TextAreaModel)this.getModel();
        TextArea text = new TextArea(model.getAttributeToString("text"));
        this.updateFigure(text, model);
        return text;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        TextAreaModel model = (TextAreaModel)this.getModel();
        TextArea text = (TextArea)this.getFigure();
        this.updateFigure(text, model);
    }

    private void updateFigure(TextArea text, TextAreaModel model) {
        text.setToolTip((IFigure)new Label(model.toString()));
        text.setText(model.getAttributeToString("text"));
        AIRPlugin.getDefault().getFontManager().setFont(model, (IFigure)text);
        text.repaint();
    }

    protected String getDirectEditPropertyKey() {
        return "text";
    }

    protected IFigure getDirectEditFigure() {
        return ((TextArea)this.getFigure()).getTextFigure();
    }
}

