/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts.command;

import java.util.ArrayList;
import java.util.List;
import net.sf.amateras.air.mxml.models.AbstractComponentModel;
import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrphanChildrenCommand
extends Command {
    private List<EditPart> editParts;
    private List<IContainerModel> oldParentModel;
    private List<FlexRectangle> oldRectangles;
    private List<Integer> oldChildIndex;

    public OrphanChildrenCommand(List<EditPart> editParts) {
        this.editParts = editParts;
        this.oldParentModel = new ArrayList<IContainerModel>();
        this.oldRectangles = new ArrayList<FlexRectangle>();
        this.oldChildIndex = new ArrayList<Integer>();
    }

    public void execute() {
        for (EditPart editPart : this.editParts) {
            AbstractComponentModel model = (AbstractComponentModel)editPart.getModel();
            this.oldParentModel.add(model.getRoot());
            this.oldRectangles.add(model.getConstraint().clone());
            this.oldChildIndex.add(model.getRoot().getChildIndex(model));
            model.getRoot().removeChild(model);
        }
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        int i = 0;
        while (i < this.editParts.size()) {
            EditPart editPart = this.editParts.get(i);
            IContainerModel model = this.oldParentModel.get(i);
            FlexRectangle rec = this.oldRectangles.get(i);
            ((IComponentModel)editPart.getModel()).setConstraint(rec);
            model.addChild(this.oldChildIndex.get(i), (IComponentModel)editPart.getModel());
            ++i;
        }
    }
}

