/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.factory;

import java.util.ArrayList;
import java.util.List;
import net.sf.amateras.air.mxml.VisualMXMLEditor;
import net.sf.amateras.air.mxml.action.AddCanvasAction;
import net.sf.amateras.air.mxml.action.AddCanvasContributionItem;
import net.sf.amateras.air.mxml.action.AddGridDataColumnAction;
import net.sf.amateras.air.mxml.action.AddGridDataColumnContributionItem;
import net.sf.amateras.air.mxml.action.ChangeStackAction;
import net.sf.amateras.air.mxml.action.ChangeStackContributionItem;
import net.sf.amateras.air.mxml.action.IStructuredSelectionRefresh;
import net.sf.amateras.air.mxml.action.MoveDownAction;
import net.sf.amateras.air.mxml.action.MoveUpAction;
import net.sf.amateras.air.mxml.action.VisualMXMLRefreshAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuFactory {
    public static final String MENU_GROUP_EDIT = "edit";
    public static final String MENU_GROUP_COMPONENT = "component";
    public static final String MENU_GROUP_ADDITIONS = "additions";
    private MoveUpAction moveUpAction;
    private MoveDownAction moveDownAction;
    private VisualMXMLRefreshAction refreshAction;
    private AddGridDataColumnAction addGridDataGridColumnAction;
    private AddCanvasAction addCanvasAction;
    private ChangeStackAction changeStackAction;
    private List<IStructuredSelectionRefresh> actions;
    private VisualMXMLEditor editor;

    public MenuFactory(VisualMXMLEditor editor) {
        this.editor = editor;
        this.actions = new ArrayList<IStructuredSelectionRefresh>();
        this.moveUpAction = new MoveUpAction(editor);
        this.moveDownAction = new MoveDownAction(editor);
        this.refreshAction = new VisualMXMLRefreshAction(editor);
        this.addGridDataGridColumnAction = new AddGridDataColumnAction(editor);
        this.addCanvasAction = new AddCanvasAction(editor);
        this.changeStackAction = new ChangeStackAction(editor);
        this.actions.add(this.moveUpAction);
        this.actions.add(this.moveDownAction);
        this.actions.add(this.refreshAction);
    }

    public List<IStructuredSelectionRefresh> getRefreshActions() {
        return this.actions;
    }

    public MenuManager createGraphicalViewerMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new Separator(MENU_GROUP_EDIT));
        menuMgr.add(this.editor.getAction(ActionFactory.UNDO.getId()));
        menuMgr.add(this.editor.getAction(ActionFactory.REDO.getId()));
        menuMgr.add(this.editor.getAction(ActionFactory.DELETE.getId()));
        AddGridDataColumnContributionItem item = new AddGridDataColumnContributionItem((IAction)this.addGridDataGridColumnAction);
        this.actions.add(item);
        menuMgr.add((IContributionItem)item);
        AddCanvasContributionItem item2 = new AddCanvasContributionItem((IAction)this.addCanvasAction);
        this.actions.add(item2);
        menuMgr.add((IContributionItem)item2);
        menuMgr.add((IContributionItem)new Separator(MENU_GROUP_COMPONENT));
        menuMgr.add((IAction)this.refreshAction);
        menuMgr.add((IAction)this.moveUpAction);
        menuMgr.add((IAction)this.moveDownAction);
        ChangeStackContributionItem item3 = new ChangeStackContributionItem((IAction)this.changeStackAction);
        this.actions.add(item3);
        menuMgr.add((IContributionItem)item3);
        menuMgr.add((IContributionItem)new Separator(MENU_GROUP_ADDITIONS));
        return menuMgr;
    }

    public void setOutLinePageMenu(IPageSite pageSite) {
        IActionBars bars = pageSite.getActionBars();
        String delId = ActionFactory.DELETE.getId();
        String undoId = ActionFactory.UNDO.getId();
        String redoId = ActionFactory.REDO.getId();
        bars.setGlobalActionHandler(delId, this.editor.getAction(delId));
        bars.setGlobalActionHandler(undoId, this.editor.getAction(undoId));
        bars.setGlobalActionHandler(redoId, this.editor.getAction(redoId));
        bars.updateActionBars();
    }

    public void setOutLineContextMenu(IMenuManager menuMgr) {
        menuMgr.add((IContributionItem)new Separator(MENU_GROUP_EDIT));
        menuMgr.add(this.editor.getAction(ActionFactory.UNDO.getId()));
        menuMgr.add(this.editor.getAction(ActionFactory.REDO.getId()));
        menuMgr.add(this.editor.getAction(ActionFactory.DELETE.getId()));
        menuMgr.add((IContributionItem)new Separator(MENU_GROUP_COMPONENT));
        menuMgr.add((IAction)this.refreshAction);
        menuMgr.add((IAction)this.moveUpAction);
        menuMgr.add((IAction)this.moveDownAction);
    }

    public MoveUpAction getMoveUpAction() {
        return this.moveUpAction;
    }

    public MoveDownAction getMoveDownAction() {
        return this.moveDownAction;
    }
}

