/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.figures;

import net.sf.amateras.air.mxml.figures.BoxFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;

public class PanelFigure
extends BoxFigure {
    private Color borderColor;
    private Color titleColor;
    private String title;
    private int borderWidth = 15;
    private int borderTopWidth = 30;
    private int borderBottomWidth = 15;
    private Insets padding = new Insets(0, 0, 0, 0);
    private MarginBorder paddingBorder = new MarginBorder(this.padding);

    public PanelFigure() {
        CompoundBorder border = new CompoundBorder((Border)new MyBorder(), (Border)this.paddingBorder);
        this.setBorder((Border)border);
        this.setOpaque(true);
    }

    public void setPadding(Insets insets) {
        this.padding.top = insets.top;
        this.padding.bottom = insets.bottom;
        this.padding.left = insets.left;
        this.padding.right = insets.right;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.repaint();
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public int getBorderTopWidth() {
        return this.borderTopWidth;
    }

    public void setBorderTopWidth(int borderTopWidth) {
        this.borderTopWidth = borderTopWidth;
    }

    public int getBorderBottomWidth() {
        return this.borderBottomWidth;
    }

    public void setBorderBottomWidth(int borderBottomWidth) {
        this.borderBottomWidth = borderBottomWidth;
    }

    class MyBorder
    extends LineBorder {
        MyBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(PanelFigure.this.borderTopWidth, PanelFigure.this.borderWidth, PanelFigure.this.borderBottomWidth, PanelFigure.this.borderWidth);
        }

        public Color getColor() {
            return PanelFigure.this.borderColor;
        }

        public int getWidth() {
            return PanelFigure.this.borderWidth;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            super.paint(figure, graphics, insets);
            try {
                graphics.setForegroundColor(PanelFigure.this.borderColor);
                int x = figure.getBounds().x;
                int y = figure.getBounds().y;
                int width = figure.getBounds().width;
                int height = figure.getBounds().height;
                graphics.setLineWidth(PanelFigure.this.borderTopWidth);
                graphics.drawLine(x, y + PanelFigure.this.borderTopWidth / 2, x + width, y + PanelFigure.this.borderTopWidth / 2);
                graphics.setLineWidth(PanelFigure.this.borderBottomWidth);
                graphics.drawLine(x, y + height - PanelFigure.this.borderBottomWidth / 2, x + width, y + height - PanelFigure.this.borderBottomWidth / 2);
                if (PanelFigure.this.titleColor != null) {
                    graphics.setForegroundColor(PanelFigure.this.titleColor);
                }
                if (PanelFigure.this.title != null) {
                    graphics.drawString(PanelFigure.this.title, x + PanelFigure.this.borderTopWidth / 2, y + 10);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

