/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.figures;

import net.sf.amateras.air.mxml.figures.AccordionFigure;
import net.sf.amateras.air.mxml.figures.LinedMarginBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class TopLabelBorder
extends LinedMarginBorder {
    private Label label = new Label();

    public TopLabelBorder(Insets paddingInsets, int borderWidth, Color borderColor) {
        super(paddingInsets, borderWidth, borderColor);
    }

    public Insets getInsets(IFigure figure) {
        this.label.setFont(figure.getFont());
        Insets insets = super.getInsets(figure);
        if (figure.getParent() instanceof AccordionFigure) {
            insets.top += this.label.getPreferredSize().height;
        }
        return insets;
    }

    public Label getTitleLabel() {
        return this.label;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        super.paint(figure, graphics, insets);
        try {
            if (figure.getParent() instanceof AccordionFigure) {
                graphics.setForegroundColor(ColorConstants.white);
                graphics.setBackgroundColor(ColorConstants.button);
                Rectangle rec = figure.getBounds();
                this.label.setFont(figure.getFont());
                this.label.setForegroundColor(figure.getForegroundColor());
                graphics.fillGradient(rec, true);
                if (this.label.getForegroundColor() != null) {
                    graphics.setForegroundColor(this.label.getForegroundColor());
                } else {
                    graphics.setForegroundColor(ColorConstants.black);
                }
                int x = figure.getBounds().x;
                int y = figure.getBounds().y;
                this.label.setBounds(new Rectangle(x, y, 100, 20));
                this.label.paint(graphics);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

