/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.models.AbstractContainerModel;
import net.sf.amateras.air.mxml.models.AbstractModel;
import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.util.ColorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentModel
extends AbstractModel
implements IComponentModel {
    protected static final String[] LIST_IME_MODE = new String[]{"", "ALPHANUMERIC_FULL", "ALPHANUMERIC_HALF", "CHINESE", "JAPANESE_HIRAGANA", "JAPANESE_KATAKANA_FULL", "JAPANESE_KATAKANA_HALF", "KOREAN"};
    protected static final String[] LIST_BORDER_STYLE = new String[]{"none", "solid", "inset", "outset"};
    protected static final String[] LIST_FONT_STYLE = new String[]{"normal", "italic"};
    protected static final String[] LIST_FONT_WEIGHT = new String[]{"normal", "bold"};
    protected static final String[] LIST_LEFT_RIGHT_CENTER = new String[]{"left", "right", "center"};
    protected static final String[] LIST_FONT_ALIAS_TYPE = new String[]{"advanced", "normal"};
    protected static final String[] LIST_GRID_FIT_TYPE = new String[]{"pixel", "none", "subpixel"};
    protected static final String[] LIST_TEXT_DECORATION = new String[]{"none", "underline"};
    protected static final String[] LIST_LABEL_PLACEMENT = new String[]{"right", "left", "bottom", "top"};
    protected static final String[] LIST_BUTTON_ALIGNMENT = new String[]{"left", "right", "auto"};
    protected static final String[] LIST_TITLE_ALIGNMENT = new String[]{"left", "center", "auto"};
    protected static final String[] LIST_SYSTEM_CHROME = new String[]{"none", "standard"};
    protected static final String[] LIST_WINDOW_TYPE = new String[]{"lightweight", "normal", "utility"};
    public static final String ALPHA = "alpha";
    public static final String ENABLED = "enabled";
    public static final String ERROR_STRING = "errorString";
    public static final String VISIBLE = "visible";
    public static final String CONSTRAINT = "constraint";
    public static final String STYLE_NAME = "styleName";
    public static final String TOOL_TIP = "toolTip";
    public static final String DOUBLE_CLICK_ENABLED = "doubleClickEnabled";
    public static final String FOCUS_ENABLED = "focusEnabled";
    public static final String MOUSE_FOCUS_ENABLED = "mouseFocusEnabled";
    public static final String ERROR_COLOR = "errorColor";
    public static final String THEME_COLOR = "themeColor";
    public static final String MAX_HEIGHT = "maxHeight";
    public static final String MAX_WIDTH = "maxWidth";
    public static final String MIN_HEIGHT = "minHeight";
    public static final String MIN_WIDTH = "minWidth";
    public static final String CLICK = "click";
    public static final String DOUBLE_CLICK = "doubleClick";
    public static final String INVALID = "invalid";
    public static final String VALID = "valid";
    public static final String HIDE = "hide";
    public static final String SHOW = "show";
    public static final String INITIALIZE = "initialize";
    protected FlexRectangle constraint;
    private IContainerModel root;
    private ArrayList<IComponentModel> children = new ArrayList();

    @Override
    protected void installModelProperty() {
        super.installModelProperty();
        this.addDoubleModelProperty(ALPHA, "Properties", null);
        this.addBooleanModelProperty(ENABLED, "Properties", true);
        this.addStringModelProperty(ERROR_STRING, "Properties");
        this.addBooleanModelProperty(VISIBLE, "Properties", true);
        this.addStringModelProperty(STYLE_NAME, "Properties");
        this.addStringModelProperty(TOOL_TIP, "Properties");
        this.addBooleanModelProperty(DOUBLE_CLICK_ENABLED, "Properties", false);
        this.addBooleanModelProperty(FOCUS_ENABLED, "Properties", true);
        this.addBooleanModelProperty(MOUSE_FOCUS_ENABLED, "Properties", true);
        this.addNumberModelProperty(MAX_HEIGHT, "Properties");
        this.addNumberModelProperty(MAX_WIDTH, "Properties");
        this.addNumberModelProperty(MIN_HEIGHT, "Properties");
        this.addNumberModelProperty(MIN_HEIGHT, "Properties");
        this.addColorModelProperty(ERROR_COLOR, "Styles", ColorUtil.toRGB("#FF0000"));
        this.addColorModelProperty(THEME_COLOR, "Styles");
        this.addStringModelProperty(CLICK, "Events");
        this.addStringModelProperty(DOUBLE_CLICK, "Events");
        this.addStringModelProperty(INVALID, "Events");
        this.addStringModelProperty(VALID, "Events");
        this.addStringModelProperty(SHOW, "Events");
        this.addStringModelProperty(VALID, "Events");
        this.addWidthHeightModelProperty("x", "Layout", "");
        this.addWidthHeightModelProperty("y", "Layout", "");
        this.addWidthHeightModelProperty("width", "Layout", "");
        this.addWidthHeightModelProperty("height", "Layout", "");
    }

    @Override
    public void fireChildPropertyChange() {
        this.firePropertyChange("_children", null, null);
    }

    public void moveDown() {
        IContainerModel root = this.getRoot();
        int index = root.getChildIndex(this);
        root.getChildren().remove(this);
        root.getChildren().add(index + 1, this);
        root.fireChildPropertyChange();
    }

    public boolean isMoveDownEnabled() {
        IContainerModel root = this.getRoot();
        int index = root.getChildIndex(this) + 1;
        return index < root.getChildren().size();
    }

    public void moveUp() {
        IContainerModel root = this.getRoot();
        int index = root.getChildIndex(this);
        root.getChildren().remove(this);
        root.getChildren().add(index - 1, this);
        root.fireChildPropertyChange();
    }

    public boolean isMoveUpEnabled() {
        IContainerModel root = this.getRoot();
        int index = root.getChildIndex(this);
        return index != 0;
    }

    @Override
    public void setRoot(IContainerModel root) {
        this.root = root;
    }

    @Override
    public IContainerModel getRoot() {
        return this.root;
    }

    @Override
    public FlexRectangle getConstraint() {
        return this.constraint;
    }

    @Override
    public void setConstraint(FlexRectangle constraint) {
        this.constraint = constraint;
        this.setPropertyValue("_x", constraint.getStrX(), false);
        this.setPropertyValue("_y", constraint.getStrY(), false);
        this.setPropertyValue("_width", constraint.getStrWidth(), false);
        this.setPropertyValue("_height", constraint.getStrHeight(), false);
        this.firePropertyChange("_constraint", null, constraint);
    }

    protected abstract String getComponentName();

    @Override
    public String toMXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(AIRPlugin.getDefault().getNameSpacePrefix()).append(this.getComponentName());
        sb.append(this.getAttributesXML());
        sb.append(this.getAdditionalAttributesXML());
        String childNodeXML = this.getChildAllNodeXML();
        if (childNodeXML != null && childNodeXML.length() != 0) {
            sb.append(">").append("\n");
            sb.append(childNodeXML);
            sb.append("</").append(AIRPlugin.getDefault().getNameSpacePrefix()).append(this.getComponentName()).append(">");
        } else {
            sb.append("/>");
        }
        return sb.toString();
    }

    protected String getChildAllNodeXML() {
        return String.valueOf(this.getAdditionalChildElementsXML()) + this.getChildrenXML();
    }

    public String toString() {
        String str = String.valueOf(AIRPlugin.getDefault().getNameSpacePrefix()) + this.getComponentName();
        String id = this.getAttributeToString("id");
        if (id.length() > 0) {
            str = String.valueOf(str) + " (id=" + id + ")";
        }
        return str;
    }

    public int getChildIndex(IComponentModel child) {
        int index = -1;
        for (IComponentModel model : this.children) {
            ++index;
            if (model != child) continue;
            return index;
        }
        return index;
    }

    public void addChild(IComponentModel child) {
        this.addChild(this.getChildren().size(), child);
    }

    public void addChild(int index, IComponentModel child) {
        this.children.add(index, child);
        this.fireChildPropertyChange();
    }

    public List<IComponentModel> getChildren() {
        return this.children;
    }

    public void removeChild(IComponentModel child) {
        boolean isRemoved = this.children.remove(child);
        if (isRemoved) {
            this.fireChildPropertyChange();
        } else {
            System.err.println("not remove child. parent=" + this + ", child=" + child);
        }
    }

    public void removeAll() {
        for (IComponentModel object : this.children) {
            if (!(object instanceof AbstractContainerModel)) continue;
            ((AbstractContainerModel)object).removeAll();
        }
        this.children.clear();
        this.fireChildPropertyChange();
    }

    protected String getChildrenXML() {
        StringBuilder sb = new StringBuilder();
        if (this.children.size() != 0) {
            Iterator<IComponentModel> ite = this.children.iterator();
            while (ite.hasNext()) {
                sb.append(((AbstractModel)((Object)ite.next())).toMXML());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public boolean canChildComponent(Object model) {
        return false;
    }

    public void addScript(String script) {
    }

    public abstract String getFlexModelPackageName();

    @Override
    public String getFlexClassName() {
        return String.valueOf(this.getFlexModelPackageName()) + "." + this.getComponentName();
    }
}

