/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.parser;

import net.sf.amateras.air.mxml.ElementWrapper;
import net.sf.amateras.air.mxml.MXMLLoader;
import net.sf.amateras.air.mxml.descriptor.BooleanPropertyDescriptor;
import net.sf.amateras.air.mxml.descriptor.DoublePropertyDescriptor;
import net.sf.amateras.air.mxml.descriptor.NumberPropertyDescriptor;
import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.IModel;
import net.sf.amateras.air.mxml.models.ModelProperty;
import net.sf.amateras.air.util.ColorUtil;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractMXMLParser {
    public IModel parse(ElementWrapper element, IContainerModel root) {
        IModel model = this.createModel();
        if (model instanceof IComponentModel) {
            ((IComponentModel)model).setRoot(root);
        }
        this.parseAttribute(model, element);
        this.parseChildren(model, element);
        return model;
    }

    protected abstract IModel createModel();

    protected void parseAttribute(IModel model, ElementWrapper element) {
        for (String key : model.getModelProperties().keySet()) {
            String value = element.getAttribute(key.substring(1));
            IPropertyDescriptor descriptor = ((ModelProperty)model.getModelProperties().get(key)).getDescriptor();
            if (value == null || value.length() <= 0) continue;
            if (descriptor instanceof ColorPropertyDescriptor) {
                model.setPropertyValue(key, ColorUtil.toRGB(value));
                continue;
            }
            if (descriptor instanceof NumberPropertyDescriptor) {
                model.setPropertyValue(key, Integer.valueOf(value));
                continue;
            }
            if (descriptor instanceof DoublePropertyDescriptor) {
                model.setPropertyValue(key, Double.valueOf(value));
                continue;
            }
            if (descriptor instanceof BooleanPropertyDescriptor) {
                if (((BooleanPropertyDescriptor)descriptor).getDefaultValue() == Boolean.parseBoolean(value)) continue;
                model.setPropertyValue(key, new Boolean(value));
                continue;
            }
            if (value.length() <= 0) continue;
            model.setPropertyValue(key, value);
        }
        FlexRectangle rectangle = null;
        if (model instanceof IComponentModel) {
            rectangle = this.getConstraint((IComponentModel)model, element);
            ((IComponentModel)model).setConstraint(rectangle);
        }
        model.setAdditionalAttributes(element.getAdditionalAttributes());
    }

    protected void parseChildren(IModel model, ElementWrapper element) {
        NodeList children = element.getElement().getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node instanceof Element) {
                this.parseChildElement(model, (Element)node);
            }
            ++i;
        }
    }

    protected void parseChildElement(IModel root, Element e) {
        MXMLLoader.parseElement(root, e);
    }

    private FlexRectangle getConstraint(IComponentModel model, ElementWrapper element) {
        FlexRectangle rect = new FlexRectangle();
        String x = element.getAttribute("x");
        String y = element.getAttribute("y");
        String width = element.getAttribute("width");
        String height = element.getAttribute("height");
        rect.setStrX(x);
        rect.setStrY(y);
        rect.setStrWidth(width);
        rect.setStrHeight(height);
        return rect;
    }
}

