/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.propertyPages;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.UIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class AIRPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Text descriptor;

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            return (IProject)adaptable;
        }
        return (IProject)adaptable.getAdapter(IProject.class);
    }

    protected Control createContents(Composite parent) {
        this.setTitle("AIR GEAR");
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.getProject()), "net.sf.amateras.air");
        this.setPreferenceStore((IPreferenceStore)store);
        Composite composite = this.createComposite(parent, 1);
        Composite descriptorGroup = this.createComposite(composite, 2);
        UIUtil.createLabel("Application Descriptor", descriptorGroup);
        this.descriptor = this.createText(descriptorGroup, store.getString("decriptor"));
        this.addExistCheck(this.descriptor, AIRPlugin.getResourceString("APPLICATION_DESCRIPTOR_SPEC"));
        try {
            if (this.getProject().getNature("net.sf.amateras.air.AIRFlexProjectNature") == null) {
                return composite;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return composite;
        }
        return composite;
    }

    private Composite createComposite(Composite parent, int column) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(column, false));
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    private Text createText(Composite parent, String label) {
        Text text = new Text(parent, 2048);
        text.setText(label);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private void addExistCheck(final Text text, final String errorMessage) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (text.getText().length() == 0) {
                    AIRPropertyPage.this.setErrorMessage(errorMessage);
                    AIRPropertyPage.this.setValid(false);
                } else {
                    AIRPropertyPage.this.setErrorMessage(null);
                    AIRPropertyPage.this.setValid(true);
                }
            }
        });
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.descriptor != null) {
            this.descriptor.setText(store.getDefaultString("decriptor"));
        }
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.descriptor != null) {
            store.setValue("decriptor", this.descriptor.getText());
        }
        return true;
    }
}

