/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.propertyPages;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.builder.AirBuilderManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPathPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private TableViewer viewer;
    private List<Object> libs = null;

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            return (IProject)adaptable;
        }
        return (IProject)adaptable.getAdapter(IProject.class);
    }

    protected Control createContents(Composite parent) {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.getProject()), "net.sf.amateras.air");
        this.setPreferenceStore((IPreferenceStore)store);
        this.libs = this.loadLibraries();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.viewer = new TableViewer(composite);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int column) {
                return AIRPlugin.getDefault().getImageRegistry().get("SWC_JAR");
            }

            public String getColumnText(Object element, int column) {
                if (element instanceof IFile) {
                    return ((IFile)element).getProjectRelativePath().toString();
                }
                if (element instanceof File) {
                    return ((File)element).getAbsolutePath();
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        try {
            this.viewer.setInput(this.libs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Composite buttons = new Composite(composite, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        buttons.setLayoutData((Object)new GridData(2));
        Button addWorkspaceButton = this.createButton("Add Library", buttons);
        addWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(BuildPathPropertyPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider(){

                    public Object[] getChildren(Object element) {
                        ArrayList<Object> result = new ArrayList<Object>();
                        Object[] children = super.getChildren(element);
                        int i = 0;
                        while (i < children.length) {
                            if (!(children[i] instanceof IFile) || ((IFile)children[i]).getName().endsWith(".swc")) {
                                result.add(children[i]);
                            }
                            ++i;
                        }
                        return result.toArray();
                    }
                });
                dialog.setTitle("Add Library");
                dialog.setInput((Object)BuildPathPropertyPage.this.getProject());
                dialog.setValidator(new ISelectionStatusValidator(){
                    private IStatus okStatus = new Status(0, "net.sf.amateras.air", 0, "", null);
                    private IStatus ngStatus = new Status(4, "net.sf.amateras.air", 4, "", null);

                    public IStatus validate(Object[] selection) {
                        int i = 0;
                        while (i < selection.length) {
                            if (!(selection[i] instanceof IFile)) {
                                return this.ngStatus;
                            }
                            if (!((IFile)selection[i]).getName().endsWith(".swc")) {
                                return this.ngStatus;
                            }
                            if (BuildPathPropertyPage.this.libs.contains(selection[i])) {
                                return this.ngStatus;
                            }
                            ++i;
                        }
                        if (selection.length == 0) {
                            return this.ngStatus;
                        }
                        return this.okStatus;
                    }
                });
                if (dialog.open() == 0) {
                    Object[] results = dialog.getResult();
                    int i = 0;
                    while (i < results.length) {
                        BuildPathPropertyPage.this.libs.add((IFile)results[i]);
                        ++i;
                    }
                    BuildPathPropertyPage.this.viewer.refresh();
                }
            }
        });
        Button removeButton = this.createButton("Remove", buttons);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)BuildPathPropertyPage.this.viewer.getSelection();
                BuildPathPropertyPage.this.libs.removeAll(sel.toList());
                BuildPathPropertyPage.this.viewer.refresh();
            }
        });
        return composite;
    }

    protected void performDefaults() {
        this.libs.clear();
        this.viewer.refresh();
    }

    private List<Object> loadLibraries() {
        IPreferenceStore store = this.getPreferenceStore();
        String libraries = store.getString("flexLibraries");
        ArrayList<Object> result = new ArrayList<Object>();
        String[] dim = libraries.split("\t");
        IProject project = this.getProject();
        int i = 0;
        while (i < dim.length) {
            try {
                if (dim[i].length() != 0) {
                    IFile file = (IFile)project.findMember((IPath)new Path(dim[i]));
                    if (file != null) {
                        result.add(file);
                    } else {
                        result.add(dim[i]);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
        return result;
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.libs.size()) {
            IFile file = (IFile)this.libs.get(i);
            String path = file.getProjectRelativePath().removeFirstSegments(0).toString();
            sb.append(path).append("\t");
            ++i;
        }
        store.setValue("flexLibraries", sb.toString().trim());
        AirBuilderManager.doClean(this.getProject());
        return true;
    }

    private Button createButton(String text, Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(768));
        return button;
    }
}

