/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.propertyPages;

import java.util.List;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.builder.AirBuilderManager;
import net.sf.amateras.air.builder.CompileProperty;
import net.sf.amateras.air.propertyPages.CreateBuildSettingDialog;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class BuildPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private TableViewer viewer;
    private List<CompileProperty> compiles = null;

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            return (IProject)adaptable;
        }
        return (IProject)adaptable.getAdapter(IProject.class);
    }

    private ScopedPreferenceStore getScopedPreferenceStore() {
        return new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.getProject()), "net.sf.amateras.air");
    }

    protected Control createContents(Composite parent) {
        ScopedPreferenceStore store = this.getScopedPreferenceStore();
        this.setPreferenceStore((IPreferenceStore)store);
        this.compiles = CompileProperty.load((IPreferenceStore)store);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.viewer = new TableViewer(composite);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int column) {
                return AIRPlugin.getDefault().getImageRegistry().get("SOURCE_FOLDER");
            }

            public String getColumnText(Object element, int column) {
                return element.toString();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        try {
            this.viewer.setInput(this.compiles);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Composite buttons = new Composite(composite, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        buttons.setLayoutData((Object)new GridData(2));
        Button addWorkspaceButton = this.createButton("Add Directory", buttons);
        addWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(BuildPropertyPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setAllowMultiple(false);
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return element.equals(BuildPropertyPage.this.getProject()) || element instanceof IFolder;
                    }
                });
                dialog.setTitle("Add Directory");
                dialog.setInput((Object)BuildPropertyPage.this.getProject().getWorkspace().getRoot());
                if (dialog.open() == 0) {
                    Object[] results = dialog.getResult();
                    int i = 0;
                    while (i < results.length) {
                        CompileProperty prop = new CompileProperty();
                        if (results[i] instanceof IProject) {
                            prop.setDirectory("");
                        } else {
                            prop.setDirectory(((Folder)results[i]).getProjectRelativePath().toString());
                        }
                        CreateBuildSettingDialog dialog2 = new CreateBuildSettingDialog(BuildPropertyPage.this.getShell(), BuildPropertyPage.this.getProject(), prop);
                        if (dialog2.open() == 0) {
                            BuildPropertyPage.this.compiles.add(prop);
                            BuildPropertyPage.this.viewer.refresh();
                        }
                        dialog2 = null;
                        ++i;
                    }
                }
            }
        });
        Button settingButton = this.createButton("Setting", buttons);
        settingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)BuildPropertyPage.this.viewer.getSelection();
                if (sel.size() > 0) {
                    CreateBuildSettingDialog dialog2 = new CreateBuildSettingDialog(BuildPropertyPage.this.getShell(), BuildPropertyPage.this.getProject(), (CompileProperty)sel.getFirstElement());
                    dialog2.open();
                    dialog2 = null;
                    BuildPropertyPage.this.viewer.refresh();
                }
            }
        });
        Button removeButton = this.createButton("Remove", buttons);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)BuildPropertyPage.this.viewer.getSelection();
                BuildPropertyPage.this.compiles.removeAll(sel.toList());
                BuildPropertyPage.this.viewer.refresh();
            }
        });
        return composite;
    }

    protected void performDefaults() {
        this.compiles.clear();
        this.viewer.refresh();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("flexCompiles", CompileProperty.export(this.compiles));
        WorkbenchPlugin.getDefault().getDecoratorManager().updateForEnablementChange();
        AirBuilderManager.doClean(this.getProject());
        return true;
    }

    private Button createButton(String text, Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(768));
        return button;
    }
}

