/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.templates;

import java.util.StringTokenizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;

public class ActionScriptTemplateContext
extends DocumentTemplateContext {
    public ActionScriptTemplateContext(TemplateContextType type, IDocument document, int offset, int length) {
        super(type, document, offset, length);
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        return super.evaluate(ActionScriptTemplateContext.correctIndention(template, this.getDocument(), this.getStart()));
    }

    public static Template correctIndention(Template template, IDocument d, int offset) {
        if (offset == -1 || d.getLength() == 0) {
            return template;
        }
        String pattern = template.getPattern();
        String delim = d.getLegalLineDelimiters()[0];
        StringBuffer buf = new StringBuffer();
        String[] stringArray = d.getLegalLineDelimiters();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nl = stringArray[n2];
            if (nl.equals("\n")) {
                delim = nl;
            }
            ++n2;
        }
        if (pattern.indexOf(10) < 0 && pattern.indexOf(13) < 0) {
            return template;
        }
        try {
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion info = d.getLineInformationOfOffset(p);
            int start = info.getOffset();
            int end = ActionScriptTemplateContext.findEndOfWhiteSpace(d, start, offset);
            buf = new StringBuffer(delim);
            if (end > start) {
                buf.append(d.get(start, end - start));
            }
            String indent = buf.toString();
            buf = new StringBuffer();
            StringTokenizer tokenizer = new StringTokenizer(pattern, "\r\n\t", true);
            char lastnl = '\u0000';
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                char c = token.charAt(0);
                if (c == '\n' || c == '\r') {
                    if (lastnl == '\u0000' || lastnl == c) {
                        buf.append(indent);
                    }
                    lastnl = c;
                    continue;
                }
                lastnl = '\u0000';
                buf.append(token);
            }
            return new Template(template.getName(), template.getDescription(), template.getContextTypeId(), buf.toString(), template.isAutoInsertable());
        }
        catch (BadLocationException badLocationException) {
            return template;
        }
    }

    private static int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }
}

