/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.wizards;

import java.util.List;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.launch.LaunchADTConfiguration;
import net.sf.amateras.air.util.ProcessUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADTRunner {
    public boolean run(IProject project, List<String> option, List<IResource> exportResources) {
        if (exportResources != null) {
            int i = 0;
            while (i < exportResources.size()) {
                IResource resource = exportResources.get(i);
                option.add(resource.getProjectRelativePath().toOSString());
                ++i;
            }
        }
        return this.run(project, option);
    }

    public boolean run(IProject project, List<String> option) {
        IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
        if (project == null || !ProcessUtil.checkAirGearProject(project)) {
            return false;
        }
        String adtPath = store.getString("adtCommand");
        String sdkPath = ProcessUtil.getAirSdkPath(adtPath);
        if (sdkPath == null) {
            return false;
        }
        try {
            ILaunchConfigurationWorkingCopy config = LaunchADTConfiguration.getADTConfiguration(project, option.get(0));
            config.setAttribute("air.PROJECT", project.getName());
            config.setAttribute("air.OPTIONS", option);
            DebugUIPlugin.launchInBackground((ILaunchConfiguration)config, (String)"run");
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

