/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.wizards.AbstractAIRProjectPropertiesWizardPage;
import net.sf.amateras.air.wizards.AbstractNewProjectWizard;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.wizard.WizardPage;

public abstract class AbstractNewAIRProjectWizard
extends AbstractNewProjectWizard {
    String icon16;
    String icon32;
    String icon48;
    String icon128;
    String descriptorTemplateName;

    protected Map createParamMap(WizardPage page) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (page instanceof AbstractAIRProjectPropertiesWizardPage) {
            AbstractAIRProjectPropertiesWizardPage wpage = (AbstractAIRProjectPropertiesWizardPage)this.page2;
            String applicationId = wpage.getApplicationId();
            String applicationName = wpage.getApplicationName();
            String applicationDescription = wpage.getApplicationDescription();
            String copyright = wpage.getCopyright();
            String visible = wpage.getVisible();
            this.descriptorTemplateName = wpage.getDescriptorTemplateName();
            this.icon16 = wpage.getIcon16();
            this.icon32 = wpage.getIcon32();
            this.icon48 = wpage.getIcon48();
            this.icon128 = wpage.getIcon128();
            params.put("applicationId", applicationId);
            params.put("applicationName", applicationName);
            params.put("description", applicationDescription);
            params.put("copyright", copyright);
            params.put("visible", visible);
            params.put("icon_16", new File(this.icon16).getName());
            params.put("icon_32", new File(this.icon32).getName());
            params.put("icon_48", new File(this.icon48).getName());
            params.put("icon_128", new File(this.icon128).getName());
        }
        return params;
    }

    protected void createResource(IProject newProjectHandle, IProgressMonitor monitor, Map params) {
        try {
            IFolder icons = newProjectHandle.getFolder("icons");
            icons.create(true, true, monitor);
            if (this.icon16.length() > 0) {
                this.createFile(newProjectHandle, "icons/" + params.get("icon_16"), new FileInputStream(this.icon16), null, monitor);
            }
            if (this.icon32.length() > 0) {
                this.createFile(newProjectHandle, "icons/" + params.get("icon_32"), new FileInputStream(this.icon32), null, monitor);
            }
            if (this.icon48.length() > 0) {
                this.createFile(newProjectHandle, "icons/" + params.get("icon_48"), new FileInputStream(this.icon48), null, monitor);
            }
            if (this.icon128.length() > 0) {
                this.createFile(newProjectHandle, "icons/" + params.get("icon_128"), new FileInputStream(this.icon128), null, monitor);
            }
            this.createProjectSpecificResources(newProjectHandle, this.descriptorTemplateName, params, monitor);
        }
        catch (Exception ex) {
            AIRPlugin.logException(ex);
        }
    }

    protected ByteArrayInputStream getTemplateContents(String templateName) throws UnsupportedEncodingException {
        AIRPlugin plugin = AIRPlugin.getDefault();
        TemplateStore templateStore = plugin.getTemplateDescriptorStore();
        Template t = templateStore.findTemplate(templateName);
        Template template = new Template(t.getName(), t.getDescription(), t.getContextTypeId(), t.getPattern(), false);
        return new ByteArrayInputStream(template.getPattern().getBytes("UTF-8"));
    }
}

