/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.wizards.file;

import java.util.List;
import java.util.Map;
import net.sf.amateras.air.builder.CompileProperty;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileCreationPage
extends WizardPage {
    private ISelection selection;
    private Text containerText;
    private Text packageText;
    private Text fileText;
    private String template;

    public AbstractFileCreationPage(ISelection selection) {
        super("wizardPage");
        this.selection = selection;
    }

    public abstract String getExtension();

    public abstract Map<String, String> getParameters();

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("Source &folder:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractFileCreationPage.this.dialogChanged();
            }
        };
        this.containerText.addModifyListener(modifyListener);
        Button button = new Button(container, 8);
        button.setText("&Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractFileCreationPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&Package:");
        this.packageText = new Text(container, 2052);
        gd = new GridData(768);
        this.packageText.setLayoutData((Object)gd);
        this.packageText.addModifyListener(modifyListener);
        new Label(container, 0);
        label = new Label(container, 0);
        label.setText("&FileName:");
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(modifyListener);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                AbstractFileCreationPage.this.modifyTextToFileName(AbstractFileCreationPage.this.fileText.getText());
            }
        });
        new Label(container, 0);
        this.setLayoutText(container, modifyListener);
        label = new Label(container, 0);
        label.setText("&Template:");
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Button) {
                    Button b = (Button)e.widget;
                    AbstractFileCreationPage.this.template = b.getText().replaceAll("&", "");
                }
            }
        };
        Composite group = new Composite(container, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new RowLayout());
        this.setTemplateLayout(group, adapter);
        new Label(container, 0);
        this.setLayoutOption(container);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    protected void setLayoutText(Composite container, ModifyListener modifyListener) {
    }

    protected void setLayoutOption(Composite container) {
    }

    protected void modifyTextToFileName(String fileName) {
    }

    public abstract void setTemplateLayout(Composite var1, SelectionAdapter var2);

    private void initialize() {
        IStructuredSelection ssel;
        Object obj;
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection && (obj = (ssel = (IStructuredSelection)this.selection).getFirstElement()) instanceof IResource) {
            this.setContainer((IResource)obj);
        }
        this.packageText.setSelection(this.packageText.getText().length());
        this.packageText.setFocus();
    }

    private void setContainer(IResource resource) {
        IContainer cont = this.getSourceFolder(resource);
        if (cont != null) {
            String pack = this.getPackageName(resource, cont);
            if (!pack.equals("")) {
                this.packageText.setText(pack);
            }
        } else {
            cont = resource instanceof IContainer ? (IContainer)resource : resource.getParent();
        }
        this.containerText.setText(cont.getFullPath().toString());
    }

    private IContainer getSourceFolder(IResource resource) {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(resource.getProject()), "net.sf.amateras.air");
        List<CompileProperty> properties = CompileProperty.load((IPreferenceStore)store);
        for (CompileProperty property : properties) {
            if (property.getDirectory() == null || property.getDirectory().length() == 0) continue;
            IFolder folder = resource.getProject().getFolder(property.getDirectory());
            if (!resource.getProjectRelativePath().toString().startsWith(property.getDirectory())) continue;
            return folder;
        }
        return resource.getProject();
    }

    private String getPackageName(IResource resource, IContainer container) {
        String folder = resource instanceof IFile ? resource.getProjectRelativePath().removeLastSegments(1).toString() : resource.getProjectRelativePath().toString();
        if ((folder = folder.substring(container.getProjectRelativePath().toString().length())).startsWith("/")) {
            folder = folder.substring(1);
        }
        if (folder.endsWith("/")) {
            folder = folder.substring(0, folder.length() - 1);
        }
        folder = folder.replaceAll("/", ".");
        return folder;
    }

    private void handleBrowse() {
        Object[] result;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)root, false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length >= 1) {
            this.setContainer((IResource)root.getFolder((IPath)result[0]));
        }
    }

    protected void dialogChanged() {
        Path contPath = new Path(this.getContainerName());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource container = root.findMember((IPath)contPath);
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("File container has to be a existing container.");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must not contain slashes");
            return;
        }
        if (fileName.indexOf(46) > 0) {
            this.updateStatus("File name must not contain dots");
            return;
        }
        IResource file = root.findMember(this.getFilePath());
        if (file != null) {
            this.updateStatus("File already exists");
            return;
        }
        if (!this.checkOther()) {
            return;
        }
        this.updateStatus(null);
    }

    protected boolean checkOther() {
        return true;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getPackageName() {
        return this.packageText.getText();
    }

    public IPath getFilePath() {
        Path path = new Path(this.getContainerName());
        path = path.append(this.getPackageName().replace('.', '/'));
        path = path.addTrailingSeparator();
        String fileName = this.getFileName();
        if (!fileName.endsWith(this.getExtension())) {
            fileName = String.valueOf(fileName) + this.getExtension();
        }
        path = path.append(fileName);
        return path;
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }
}

