/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.wizards.file;

import java.util.HashMap;
import java.util.Map;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.wizards.file.AbstractFileCreationPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardNewMxmlFileCreationPage
extends AbstractFileCreationPage {
    private Text titleText;
    private Button includeScript;
    private Text scriptFooter;

    public WizardNewMxmlFileCreationPage(ISelection selection) {
        super(selection);
        this.setTitle("MXML Editor File");
        this.setDescription("This wizard creates a new file with *.mxml extension that can be opened by a mxml editor.");
    }

    @Override
    protected void setLayoutText(Composite container, ModifyListener modifyListener) {
        super.setLayoutText(container, modifyListener);
        Label label = new Label(container, 0);
        label.setText("&Title:");
        this.titleText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.titleText.setLayoutData((Object)gd);
        this.titleText.addModifyListener(modifyListener);
        new Label(container, 0);
    }

    @Override
    protected void setLayoutOption(Composite container) {
        super.setLayoutOption(container);
        this.includeScript = new Button(container, 32);
        this.includeScript.setText("&Include Script");
        this.scriptFooter = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.scriptFooter.setLayoutData((Object)gd);
        this.scriptFooter.setText("Script.as");
        new Label(container, 0);
    }

    @Override
    protected void modifyTextToFileName(String fileName) {
        super.modifyTextToFileName(fileName);
        this.scriptFooter.setText(String.valueOf(fileName) + "Script.as");
    }

    @Override
    public void setTemplateLayout(Composite group, SelectionAdapter adapter) {
        Button button = new Button(group, 16);
        button.setText("&Simple");
        button.addSelectionListener((SelectionListener)adapter);
        button = new Button(group, 16);
        button.setText("&WindowedApplication");
        button.setSelection(true);
        button.addSelectionListener((SelectionListener)adapter);
        button = new Button(group, 16);
        button.setText("&Application");
        button.addSelectionListener((SelectionListener)adapter);
        button = new Button(group, 16);
        button.setText("&TitleWindow");
        button.addSelectionListener((SelectionListener)adapter);
        button = new Button(group, 16);
        button.setText("&Window");
        button.addSelectionListener((SelectionListener)adapter);
        this.setTemplate("Application");
    }

    @Override
    public String getExtension() {
        return ".mxml";
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("title", this.titleText.getText());
        params.put("file_name", this.getFileName());
        if (this.includeScript.getSelection()) {
            String script = "<" + AIRPlugin.getDefault().getNameSpacePrefix() + "Script source=\"" + this.scriptFooter.getText() + "\" />";
            params.put("script", script);
            params.put("script_footer", this.scriptFooter.getText());
        } else {
            params.put("script", "");
        }
        return params;
    }
}

