package net.java.amateras.db.visual.action;

import java.util.ArrayList;
import java.util.List;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.dialect.DialectProvider;
import net.java.amateras.db.dialect.IDialect;
import net.java.amateras.db.visual.editpart.TableEditPart;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectedTablesDDLAction extends AbstractDBAction {

	public SelectedTablesDDLAction(GraphicalViewer viewer) {
		super(DBPlugin.getResourceString("action.selectedTablesDDL"), viewer);
	}
	
	@Override public void run(){
		ISelection sel = getViewer().getSelection();
		if(sel instanceof IStructuredSelection){
			List<TableModel> tableModels = new ArrayList<TableModel>();
			Object[] selected = ((IStructuredSelection) sel).toArray();
			for(Object obj: selected){
				if(obj instanceof TableEditPart){
					tableModels.add((TableModel) ((TableEditPart) obj).getModel());
				}
			}
			
			RootModel root = ((RootModel) getViewer().getContents().getModel());
			IDialect dialect = DialectProvider.getDialect(root.getDialectName());
			
			StringBuilder sb = new StringBuilder();
			
			if(tableModels.isEmpty()){
				sb.append(dialect.createDDL(root, false, false, true, true));
				
			} else {
				StringBuilder additions = new StringBuilder();
				for(TableModel tableModel: tableModels){
					sb.append(dialect.createTableDDL(root, tableModel, 
							false, false, true, true, additions));
				}
				if(additions.length() > 0){
					sb.append(System.getProperty("line.separator"));
					sb.append(additions.toString());
				}
			}
			
			DDLDisplayDialog dialog = new DDLDisplayDialog(
					Display.getDefault().getActiveShell(), sb.toString());
			dialog.open();
		}
	}
	
	private class DDLDisplayDialog extends Dialog {
		
		private String ddl;
		
		protected DDLDisplayDialog(Shell parentShell, String ddl) {
			super(parentShell);
			this.ddl = ddl;
			setShellStyle(getShellStyle()|SWT.RESIZE);
		}
		
		@Override protected Point getInitialSize() {
			return new Point(600, 450);
		}

		@Override protected Control createDialogArea(Composite parent) {
			getShell().setText("DDL");
			
			Text text = new Text(parent, SWT.BORDER|SWT.MULTI|SWT.H_SCROLL|SWT.V_SCROLL);
			text.setLayoutData(new GridData(GridData.FILL_BOTH));
			text.setText(ddl);
			text.setEditable(false);
			return text;
		}

		@Override protected void createButtonsForButtonBar(Composite parent) {
			createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL, true);
		}
	}

}
