package net.sf.amateras.air.as;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.as.format.ActionScriptFormattingStrategy;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

/**
 * Source viewer configuration for the action script editor.
 * @author hideko ogawa
 */
public class ActionScriptConfiguration extends TextSourceViewerConfiguration {

	@Override
	public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
		return new String[] { IDocument.DEFAULT_CONTENT_TYPE, ActionScriptPartitionScanner.AS_COMMENT,
				ActionScriptPartitionScanner.AS_STRING };
	}

	private RuleBasedScanner getCommentScanner() {
		RuleBasedScanner scanner = new RuleBasedScanner();
		EditorColorProvider colorProvider = AIRPlugin.getDefault().getEditorColorProvider();
		scanner.setDefaultReturnToken(colorProvider.getToken(AIRPlugin.PREF_COLOR_COMMENT));
		return scanner;
	}

	private RuleBasedScanner getStringScanner() {
		RuleBasedScanner scanner = new RuleBasedScanner();
		EditorColorProvider colorProvider = AIRPlugin.getDefault().getEditorColorProvider();
		scanner.setDefaultReturnToken(colorProvider.getToken(AIRPlugin.PREF_COLOR_STRING));
		return scanner;
	}

	private RuleBasedScanner getDefaultScanner() {
		return new ActionScriptKeywordPartitionScanner();
	}

	@Override
	public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
		PresentationReconciler reconciler = new PresentationReconciler();
		DefaultDamagerRepairer commentDR = new DefaultDamagerRepairer(getCommentScanner());
		reconciler.setDamager(commentDR, ActionScriptPartitionScanner.AS_COMMENT);
		reconciler.setRepairer(commentDR, ActionScriptPartitionScanner.AS_COMMENT);

		DefaultDamagerRepairer stringDR = new DefaultDamagerRepairer(getStringScanner());
		reconciler.setDamager(stringDR, ActionScriptPartitionScanner.AS_STRING);
		reconciler.setRepairer(stringDR, ActionScriptPartitionScanner.AS_STRING);

		DefaultDamagerRepairer keywordDR = new DefaultDamagerRepairer(getDefaultScanner());
		reconciler.setDamager(keywordDR, IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(keywordDR, IDocument.DEFAULT_CONTENT_TYPE);

		return reconciler;
	}

	@Override
	public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
		ContentAssistant assistant = new ContentAssistant();
		// AssistProcessor setting
		DefaultContentAssistProcessor processor = new DefaultContentAssistProcessor();
		assistant.setContentAssistProcessor(processor, IDocument.DEFAULT_CONTENT_TYPE);
		assistant.setInformationControlCreator(getInformationControlCreator(sourceViewer));
		assistant.install(sourceViewer);
		assistant.setProposalPopupOrientation(IContentAssistant.PROPOSAL_OVERLAY);
		assistant.setContextInformationPopupOrientation(IContentAssistant.CONTEXT_INFO_ABOVE);
		assistant.setProposalSelectorBackground(ColorConstants.tooltipBackground);
		assistant.enableAutoActivation(true);
		return assistant;
	}

	@Override
	public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
		IAutoEditStrategy[] strategies = new IAutoEditStrategy[] { new CodeFormattingStrategy() };
		return strategies;
	}

	@Override
	public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
		return new ActionScriptDoubleClickStrategy();
	}


	@Override
	public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
		MultiPassContentFormatter formatter = new MultiPassContentFormatter(
				getConfiguredDocumentPartitioning(sourceViewer), IDocument.DEFAULT_CONTENT_TYPE);
		formatter.setMasterStrategy(new ActionScriptFormattingStrategy());
		return formatter;
	}
}
