package net.sf.amateras.air.as;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.ITextEditorActionDefinitionIds;

/**
 * Text Editor for Action Script.
 * @author Naoki Takezoe
 */
public class ActionScriptEditor extends TextEditor {

	private IDocumentPartitioner partitioner = new FastPartitioner(new ActionScriptPartitionScanner(), new String[] {
			ActionScriptPartitionScanner.AS_COMMENT, ActionScriptPartitionScanner.AS_STRING });

	public ActionScriptEditor() {
		setSourceViewerConfiguration(new ActionScriptConfiguration());
	}

	@Override
	protected void doSetInput(IEditorInput input) throws CoreException {
		super.doSetInput(input);

		IDocument document = getDocumentProvider().getDocument(input);
		if (document.getDocumentPartitioner() == null) {
			partitioner.connect(document);
			document.setDocumentPartitioner(partitioner);
		}

		//		IFile file = ((IFileEditorInput) input).getFile();
		//		IProject project = file.getProject();
		//		ScopedPreferenceStore projectStore = new ScopedPreferenceStore(new ProjectScope(project),
		//				AIRPlugin.PLUGIN_ID);
		//		String descriptor = projectStore.getString(AIRPlugin.PREF_DESCRIPTOR);
		//		IFile targetFile = project.getFile(new Path(descriptor));
		//		System.out.println("mainFile is " + targetFile);

	}

	@Override
	protected void createActions() {
		super.createActions();
		IAction action = new ContentAssistAction(AIRPlugin.getResourceBundle(), "ContentAssistProposal", this);
		action.setActionDefinitionId(ITextEditorActionDefinitionIds.CONTENT_ASSIST_PROPOSALS);
		setAction("ContentAssistProposal", action);

	}

	@Override
	protected void initializeKeyBindingScopes() {
		super.initializeKeyBindingScopes();
		setKeyBindingScopes(new String[] { "net.sf.amateras.air.editor.textEditorScope" });

	}

	@Override
	protected void initializeEditor() {
		super.initializeEditor();
		//setEditorContextMenuId("#ActionScriptEditorContext");
	}

}
