package net.sf.amateras.air.as.format;

import org.eclipse.text.edits.ReplaceEdit;

/**
 * 
 * @author hideko ogawa
 */
public class ActionScriptCodeFormatter {

	public ReplaceEdit format(String contents, int offset, int length, String lineDelimiter) {
		//TODO format
		System.out.println("offset=" + offset + ", length=" + length);
		System.out.println(contents);

		//scontents = contents.replaceAll("[ \\t]+$", "");
		//contents = contents.replaceAll("^[ \\t]", "");
		//contents = contents.replaceAll(lineDelimiter, "");
		//contents = contents.replaceAll("[ ]+\\{", " {");
		//contents = contents.replaceAll("[ ]+", " ");
		//contents = contents.replaceAll("\t", "");
		//		contents = contents.replaceAll("\\{", "\\{" + lineDelimiter);
		//		contents = contents.replaceAll("\\}", "\\}" + lineDelimiter);
		//		contents = contents.replaceAll("\\;", "\\;" + lineDelimiter);

		StringBuilder sb = new StringBuilder();
		int nowIndent = 0;
		String indent = "\t";
		boolean isLineFeedAfter = false;

		char[] charArray = contents.toCharArray();
		for (int i = 0; i < charArray.length; i++) {
			char c = charArray[i];
			if (isLineFeedAfter && (c == ' ' || c == '\t')) {
				continue;
			}

			if (c == '}') {
				nowIndent--;
			}

			if (isLineFeedAfter && c != '\n') {
				for (int n = 0; n < nowIndent; n++) {
					sb.append(indent);
				}
			}
			sb.append(c);

			if (c == '\n') {
				isLineFeedAfter = true;
			} else {
				isLineFeedAfter = false;
				if (c == '{') {
					nowIndent++;
				}
			}
		}

		if (contents.equals(sb.toString())) {
			return null;
		} else {
			return new ReplaceEdit(0, sb.length(), sb.toString());
		}

	}
}
