package net.sf.amateras.air.as.format;

import java.util.LinkedList;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.FormattingContextProperties;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.ReplaceEdit;

public class ActionScriptFormattingStrategy extends ContextBasedFormattingStrategy {

	private final LinkedList<IDocument> fDocuments = new LinkedList<IDocument>();
	private final LinkedList<TypedPosition> fPartitions = new LinkedList<TypedPosition>();

	@Override
	public void format() {
		super.format();

		final IDocument document = fDocuments.removeFirst();
		final TypedPosition partition = fPartitions.removeFirst();
		if (document != null && partition != null) {
			try {

				String lineDelimiter = TextUtilities.getDefaultLineDelimiter(document);
				String contents = document.get();
				int offset = partition.getOffset();
				int length = partition.getLength();

				ActionScriptCodeFormatter formatter = new ActionScriptCodeFormatter();
				ReplaceEdit edit = formatter.format(contents, offset, length, lineDelimiter);
				if (edit != null) {
					document.set(edit.getText());
					edit.apply(document);
				}

			} catch (BadLocationException exception) {
				AIRPlugin.logException(exception);
			}
		}
	}

	@Override
	public void formatterStarts(final IFormattingContext context) {
		super.formatterStarts(context);

		fPartitions.addLast((TypedPosition) context.getProperty(FormattingContextProperties.CONTEXT_PARTITION));
		fDocuments.addLast((IDocument) context.getProperty(FormattingContextProperties.CONTEXT_MEDIUM));
	}

	@Override
	public void formatterStops() {
		super.formatterStops();

		fPartitions.clear();
		fDocuments.clear();
	}

	//	public void formatterStarts(String initialIndentation) {
	//	}
	//
	//	public String format(String content, boolean isLineStart, String indentation, int[] positions) {
	//		System.out.println("format! isLineStart=" + isLineStart + ", indentation=" + indentation + ", positions="
	//				+ positions);
	//		for (int position : positions) {
	//			System.out.println("position=" + position);
	//		}
	//		return content;
	//	}
	//
	//	public void formatterStops() {
	//	}
}
