package net.sf.amateras.air.as.syntax;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.templates.ActionScriptTemplateCompletionProcessor;
import net.sf.amateras.air.util.AIRResources;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

public class SyntaxReader {

	private String syntaxFileDirectory = "/syntax/";
	private static SyntaxReader myObject = new SyntaxReader();

	private String[] reservedWords;
	private IContentAssistHelper helper;

	private SyntaxReader() {
		//TODO: change helper.
		helper = new SampleConstantAssistHelper();
	}

	public static SyntaxReader getInstance() {
		return myObject;
	}

	/**
	 * ContentAssist result.
	 * 
	 * @param viewer
	 * @param documentOffset
	 * @return
	 */
	public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
		String previousWord = getPreviousWord(viewer.getDocument(), documentOffset);

		List<ICompletionProposal> result = new ArrayList<ICompletionProposal>();

		// add "ReservedWords"
		addCompletionProposalsReservedWords(viewer, documentOffset, previousWord, result);

		// add "TopLevel Function and Constant"
		//		addCompletionProprsalsTopLevelFunction(viewer, documentOffset, previousWord, result);

		// TODO: Class,Method and more...
		viewer.getDocument().get();
		List<ISyntaxClass> lists = helper.getSyntaxClasses(viewer.getDocument().get(), documentOffset, previousWord);
		add(lists, result);

		// add Template
		addTemplateCompletionProposal(viewer, documentOffset, result);

		Collections.sort(result, new ASProposalComparator());
		return result.toArray(new ICompletionProposal[result.size()]);
	}

	protected void addTemplateCompletionProposal(ITextViewer viewer, int documentOffset,
			List<ICompletionProposal> result) {
		ActionScriptTemplateCompletionProcessor templateProcessor = new ActionScriptTemplateCompletionProcessor();
		ICompletionProposal[] templateProposals = templateProcessor.computeCompletionProposals(viewer, documentOffset);
		for (ICompletionProposal prop : templateProposals) {
			result.add(prop);
		}
	}

	/**
	 * add Reserved Words CompletionProposal.
	 * and save.
	 * @param viewer
	 * @param documentOffset
	 * @param previousWord
	 * @param result
	 */
	protected void addCompletionProposalsReservedWords(ITextViewer viewer, int documentOffset, String previousWord,
			List<ICompletionProposal> result) {
		String[] words = getReservedWords();

		if (previousWord.length() > 0) {
			for (int i = 0; i < words.length; i++) {
				if (words[i].startsWith(previousWord)) {
					result.add(new CompletionProposal(words[i], documentOffset - previousWord.length(), previousWord
							.length(), words[i].length(), getTypeImage(ISyntaxClass.TYPE_RESERVED_WORD), words[i],
							null, null));
				}
			}
		}

	}

	private void add(List<ISyntaxClass> syntaxClasses, List<ICompletionProposal> result) {
		for (int i = 0; i < syntaxClasses.size(); i++) {
			ISyntaxClass syntax = syntaxClasses.get(i);

			ContextInformation context = null;
			if (syntax.getInformationDisplayString() != null) {
				context = new ContextInformation(null, syntax.getInformationDisplayString());
			}

			result.add(new CompletionProposal(syntax.getReplacementString(), syntax.getReplacementOffset(), syntax
					.getReplacementLength(), syntax.getCursorPosition(), getTypeImage(syntax.getType()), syntax
					.getDisplayString(), context, syntax.getAdditionalInfo()));
		}
	}

	/**
	 * get previous word to whitespace.
	 * @param document
	 * @param documentOffset
	 * @return
	 */
	private String getPreviousWord(IDocument document, int documentOffset) {
		StringBuffer buf = new StringBuffer();
		while (true) {
			try {
				char c = document.getChar(--documentOffset);
				//if (Character.isWhitespace(c) || c == '.')
				if (Character.isWhitespace(c) || c == '}' || c == ':') {
					return buf.reverse().toString();
				}

				buf.append(c);

			} catch (BadLocationException e) {
				return buf.reverse().toString();
			}
		}
	}

	/**
	 * get type image.
	 * @param type TYPE_CLASS|TYPE_PROPERTY|TYPE_METHOD
	 * @return
	 */
	public Image getTypeImage(int type) {
		if (type == ISyntaxClass.TYPE_CLASS) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CONTENTS_ASSIST_CLASS);
		} else if (type == ISyntaxClass.TYPE_PROPERTY) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CONTENTS_ASSIST_PROERTY);
		} else if (type == ISyntaxClass.TYPE_FUNCTION) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CONTENTS_ASSIST_METHOD);
		} else if (type == ISyntaxClass.TYPE_INTERFACE) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CONTENTS_ASSIST_INTERFACE);
		} else if (type == ISyntaxClass.TYPE_CONSTANT) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CONTENTS_ASSIST_RESERVED_WORD);
		} else if (type == ISyntaxClass.TYPE_RESERVED_WORD) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CONTENTS_ASSIST_RESERVED_WORD);
		} else {
			return null;
		}
	}

	/**
	 * get reserved words list from file.
	 * file is syntax/ReservedWord.txt
	 * @return
	 */
	public String[] getReservedWords() {
		if (reservedWords == null) {
			reservedWords = readStreamToStringArray("ReservedWord");
		}
		return reservedWords;
	}

	/**
	 * read file, return StringArray.
	 * @param filePath
	 * @return
	 */
	private String[] readStreamToStringArray(String filePath) {
		BufferedReader bReader = null;
		InputStream input = null;

		try {
			input = getClass().getResourceAsStream(syntaxFileDirectory + filePath);
			bReader = new BufferedReader(new InputStreamReader(input));
			String line;
			ArrayList<String> list = new ArrayList<String>();

			while ((line = bReader.readLine()) != null) {
				if (line.length() == 0) {
					continue;
				}
				list.add(line);
			}
			return list.toArray(new String[list.size()]);

		} catch (IOException e) {
			e.printStackTrace();
			return null;
		} finally {
			try {
				if (bReader != null) {
					bReader.close();
				}
				if (input != null) {
					input.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	public class ASProposalComparator implements Comparator<ICompletionProposal> {
		public int compare(ICompletionProposal p1, ICompletionProposal p2) {
			return p1.getDisplayString().compareTo(p2.getDisplayString());
		}
	}
}
