package net.sf.amateras.air.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/**
 * Provides actionScript compiler by fsch.
 * 
 * @author hideko ogawa
 */
public class CompcCompiler {

	private IProject project;
	private Map<String, String> idMap = Collections.synchronizedMap(new HashMap<String, String>());

	private Pattern pattern;

	public CompcCompiler(IProject project, Pattern pattern) {
		this.project = project;
		this.pattern = pattern;
	}

	public void setMessagePattern(Pattern pattern) {
		this.pattern = pattern;
	}

	public void dispose() {
		project = null;
		pattern = null;
		idMap.clear();
	}

	/**
	 * Requests compiling ActionScript file.
	 * 
	 * @param fileNames the relative path of requested ActionScript file.
	 * @param sourceDirectory
	 * @param compileCommand
	 * @param isLibraryPath
	 * @param fcsh fcsh process.
	 * @param moniter progress moniter.
	 */
	public String requestCompile(String compileCommand, FcshShell fcsh, IProgressMonitor monitor) throws CoreException {

		String command = null;

		StringBuilder sb = new StringBuilder();
		sb.append(compileCommand);
		sb.append("\n");
		command = sb.toString();

		if (idMap.containsKey(command)) {
			String id = idMap.get(command);
			command = "compile " + id + "\n";
		}

		monitor.setTaskName(String.format(AIRPlugin.getResourceString("COMPILE_START_COMPILE"), command));

		String result = fcsh.startCommand(command, monitor);
		Matcher matcher = pattern.matcher(result);
		if (matcher.find()) {
			String id = matcher.group(1);
			idMap.put(command, id);
		}

		project.refreshLocal(IResource.DEPTH_INFINITE, null);
		sb.append(result);
		return sb.toString();
	}

}
