package net.sf.amateras.air.debug;

import net.sf.amateras.air.debug.debugger.command.IDebuggerCommand;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;

/**
 * Debug Element of AIR GEAR.
 * @author hideko ogawa
 *
 */
public class AirDebugElement extends DebugElement {

	public AirDebugElement(IDebugTarget target) {
		super(target);
	}

	public String getModelIdentifier() {
		return AirLineBreakPoint.DEBUG_MODEL_IDENTIFIER;
	}

	public AirDebugTarget getAirDebugTarget() {
		return (AirDebugTarget) getDebugTarget();
	}

	public IBreakpointManager getBreakpointManager() {
		return DebugPlugin.getDefault().getBreakpointManager();
	}

	public IExpressionManager getExpressionManager() {
		return DebugPlugin.getDefault().getExpressionManager();
	}

	public void addDebuggerCommand(IDebuggerCommand command) {
		getAirDebugTarget().addDebuggerCommand(command);
	}

}
