package net.sf.amateras.air.debug.debugger.command;

import java.io.File;
import java.io.IOException;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ProcessUtil;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.preference.IPreferenceStore;

public class StartApplicationCommand extends AbstractDebuggerCommand {
	private String targetExecutingFileName;
	private ILaunch launch;

	public StartApplicationCommand(String targetExecutingFileName, ILaunch launch) {
		this.targetExecutingFileName = targetExecutingFileName;
		this.launch = launch;
	}

	public String getSendMessage() {
		try {
			startAirApplication();
		} catch (IOException e) {
			AIRPlugin.logException(e);
		}
		return null;
	}

	public IProcess startAirApplication() throws IOException {
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		String adlpath = store.getString(AIRPlugin.PREF_ADL_COMMAND);
		String sdkPath = ProcessUtil.getAirSdkPath(adlpath);

		if (sdkPath == null) {
			return null;
		}

		File executeFile = new File(sdkPath, adlpath);
		String[] command = new String[] { targetExecutingFileName };
		Process process = ProcessUtil.createProcess(executeFile, command, null);
		return DebugPlugin.newProcess(launch, process, "\"" + executeFile.getName() + " "
				+ new File(command[0]).getName());
	}
}
