package net.sf.amateras.air.debug.sourcelocater;

import net.sf.amateras.air.util.ResourceUtil;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.ui.IEditorInput;

/**
 * 
 * @author hideko ogawa
 *
 */
public class AirSourceLookupDirector extends AbstractSourceLookupDirector implements ISourcePresentation {

	public void initializeParticipants() {
		addParticipants(new ISourceLookupParticipant[] { new AirSourceLookupParticipant() });
	}

	public String getEditorId(IEditorInput input, Object element) {
		//		String fileName = null;
		//		if (element instanceof File) {
		//			fileName = ((File) element).getName();
		//		} else if (element instanceof LocalFileStorage) {
		//			fileName = ((LocalFileStorage) element).getName();
		//		}
		//		if (fileName.endsWith(".mxml")) {
		//			return "net.sf.amateras.air.mxml.MultiPageMXMLEditor";
		//		} else {
		//			return "net.sf.amateras.air.as.ActionScriptEditor";
		//		}
		return "net.sf.amateras.air.as.ActionScriptEditor";
	}

	public IEditorInput getEditorInput(Object element) {
		IPath filePath = null;
		if (element instanceof IFile) {
			filePath = ((IFile) element).getLocation();
			return ResourceUtil.createEditorInput(filePath.toOSString());
		} else if (element instanceof LocalFileStorage) {
			filePath = ((LocalFileStorage) element).getFullPath();
			return new AirStorageEditorInput((IStorage) element);
		}
		return null;
	}

}
