package net.sf.amateras.air.debug.sourcelocater;

import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.launch.LaunchAIRMainTab;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.WorkspaceSourceContainer;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * SourcePathComputerDelegate for AIR GEAR.
 * 
 * The source directory of FlexSDK is added. 
 * @author ogawa hideko
 *
 */
public class AirSourcePathComputerDelegate implements ISourcePathComputerDelegate {

	private static final String[] DIRS = { "frameworks/projects/framework/src", "frameworks/projects/airframework/src",
			"frameworks/projects/flex/src", "frameworks/projects/haloclassic/src", "frameworks/projects/rpc/src",
			"frameworks/projects/utilities/src" };

	public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor)
			throws CoreException {

		String path = configuration.getAttribute(LaunchAIRMainTab.ATTR_PROJECT, "");
		List<ISourceContainer> containers = new ArrayList<ISourceContainer>();
		if (path != null) {
			IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(new Path(path));
			if (resource != null) {
				if (resource.getType() == IResource.PROJECT) {
					containers.add(new ProjectSourceContainer((IProject) resource, false));
				} else if (resource.getType() == IResource.FOLDER) {
					containers.add(new FolderSourceContainer((IContainer) resource, false));
				}
			}
		}
		containers.add(new WorkspaceSourceContainer());
		//		if (sourceContainer == null) {
		//			sourceContainer = new WorkspaceSourceContainer();
		//		}

		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		String sdkPath = store.getString(AIRPlugin.PREF_FLEX_SDK_PATH);
		for (String dir : DIRS) {
			String sdkFramework = sdkPath + "/" + dir;
			IPath frameworksPath = new Path(sdkFramework);
			containers.add(new DirectorySourceContainer(frameworksPath, true));
		}

		return containers.toArray(new ISourceContainer[containers.size()]);
	}
}
