package net.sf.amateras.air.mxml.action;

import net.sf.amateras.air.mxml.editparts.ViewStackEditPart;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.ISelectedView;

import org.eclipse.gef.TreeEditPart;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * Change View ContributionItem.
 * 
 * @author ogawahideko
 *
 */
public class ChangeStackContributionItem extends ActionContributionItem implements IStructuredSelectionRefresh {

	public ChangeStackContributionItem(IAction action) {
		super(action);
		setVisible(false);
	}

	public void update(IStructuredSelection selection) {
		if (selection.getFirstElement() instanceof TreeEditPart) {
			Object model = ((TreeEditPart) selection.getFirstElement()).getModel();
			if (model instanceof IComponentModel) {
				if (((IComponentModel) model).getRoot() instanceof ISelectedView) {
					ISelectedView rootModel = (ISelectedView) ((IComponentModel) model).getRoot();
					int index = rootModel.getChildIndex((IComponentModel) model);
					rootModel.setSelectedIndex(index);
				}
			}
		} else if (selection.getFirstElement() instanceof ViewStackEditPart) {
			setVisible(true);
			ViewStackEditPart selectedStack = (ViewStackEditPart) selection.getFirstElement();
			((ChangeStackAction) getAction()).setSelectedEditPart(selectedStack);
		} else {
			setVisible(false);
			((ChangeStackAction) getAction()).setSelectedEditPart(null);
		}

		update();
	}
}
