package net.sf.amateras.air.mxml.editparts.command;

import net.sf.amateras.air.mxml.models.AbstractComponentModel;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

/**
 * MoveCommand for {@link IComponentModel}.
 * 
 * @author ogawahideko
 *
 */
public class MoveChildCommand extends Command {

	protected IComponentModel model;
	protected IContainerModel root;
	protected IContainerModel oldRoot;

	protected EditPart after;

	protected int beforeIndex = -1;
	protected int addIndex = -1;

	public MoveChildCommand(EditPart host, EditPart child, EditPart after) {
		root = (IContainerModel) host.getModel();
		model = (IComponentModel) child.getModel();
		beforeIndex = root.getChildIndex(model);
		this.after = after;

		if (after != null) {
			oldRoot = ((AbstractComponentModel) after.getModel()).getRoot();
			AbstractComponentModel afterModel = (AbstractComponentModel) after.getModel();
			if (oldRoot != null) {
				addIndex = oldRoot.getChildIndex(afterModel);
			}
		}
	}

	@Override
	public void execute() {
		if (oldRoot != null) {
			oldRoot.removeChild(model);

			if (addIndex >= 0) {
				root.addChild(addIndex, model);
			} else {
				root.addChild(model);
			}
		}
	}

	@Override
	public void undo() {
		root.removeChild(model);
		if (oldRoot != null) {
			oldRoot.addChild(beforeIndex, model);
		}
	}

	@Override
	public boolean canExecute() {
		if (root == null) {
			return false;
		}
		return root.canChildComponent(model);
	}

}
