package net.sf.amateras.air.mxml.figures;

import java.util.HashMap;
import java.util.Map;

import net.sf.amateras.air.mxml.models.FlexRectangle;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class AccordionFigure extends ContainerFigure implements MouseListener {
	private static final int DEFAULT_HEIGHT = 22;
	private static final int DEFAULT_WIDTH = 56;
	private int selectIndex = -1;
	private IFigure selectedFigure;
	private Map<IFigure, IFigure> childs = new HashMap<IFigure, IFigure>();

	public AccordionFigure() {
		setLayoutManager(new ToolbarLayout());
		setOpaque(true);
	}

	public void add(IFigure figure, String text, Object constraint, int index) {
		IFigure addFigure = new Figure();
		FlexRectangle rectangle = new FlexRectangle();
		addFigure.setBounds(rectangle);
		addFigure.setLayoutManager(new BorderLayout());
		Label label = getTitleLabel(text);
		addFigure.add(label, BorderLayout.TOP, -1);
		addFigure.add(figure, BorderLayout.CENTER, -1);
		label.addMouseListener(this);
		childs.put(figure, addFigure);
		super.add(addFigure, constraint, index);
	}

	@Override
	public void remove(IFigure figure) {
		IFigure addFigure = childs.get(figure);
		super.remove(addFigure);
	}

	private Label getTitleLabel(String text) {
		Label label = new TitleLabel();
		label.setText(text);
		return label;
	}

	@Override
	public void add(IFigure figure, Object constraint, int index) {
		//super.add(addFigure, constraint, index);
	}

	@Override
	public int getDefaultWidth() {
		return DEFAULT_WIDTH;
	}

	@Override
	public int getDefaultHeight() {
		return DEFAULT_HEIGHT;
	}

	public void setSelectedIndex(int selectIndex) {
		this.selectIndex = selectIndex;
		for (int i = 0; i < getChildren().size(); i++) {
			IFigure child = (IFigure) getChildren().get(i);
			IFigure original = (IFigure) child.getChildren().get(1);

			if (selectIndex == i) {
				original.setPreferredSize(new Dimension(getBounds().width, getBounds().height));
				selectedFigure = original;
				original.setVisible(true);

			} else {
				original.setVisible(false);
			}
		}
	}

	@Override
	public void setBounds(Rectangle rect) {
		super.setBounds(rect);
		if (selectedFigure != null) {
			selectedFigure.setPreferredSize(new Dimension(getBounds().width, getBounds().height));
		}
	}

	public void mouseDoubleClicked(MouseEvent me) {

	}

	public void mousePressed(MouseEvent me) {
		Object ms = me.getSource();
		for (int i = 0; i < getChildren().size(); i++) {
			Object obj = ((IFigure) getChildren().get(i)).getChildren().get(0);
			if (obj == ms) {
				setSelectedIndex(i);
				return;
			}
		}

	}

	public void mouseReleased(MouseEvent me) {

	}

	public int getSelectIndex() {
		return selectIndex;
	}

}
