package net.sf.amateras.air.mxml.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.ButtonBorder.ButtonScheme;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/**
 * 
 * @author Naoki Takezoe
 */
public class Button extends AbstractLabelFigure implements ColorConstants {

	private Insets padding;
	private MarginBorder marginBorder;

	public Button() {
		padding = new Insets(0, 0, 0, 0);
		marginBorder = new MarginBorder(padding);
		setBorder(marginBorder);
		installDefaultStyle();
	}

	protected void installDefaultStyle() {
		setBackgroundColor(Display.getDefault().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND));
		setOpaque(true);

		SchemeBorder myBorder = new SchemeBorder(new ButtonScheme(new Color[] { buttonLightest }, new Color[] {
				buttonDarkest, buttonDarker }));
		CompoundBorder border = new CompoundBorder(myBorder, marginBorder);
		setBorder(border);
	}

	public void setPadding(Insets insets) {
		padding.top = insets.top;
		padding.bottom = insets.bottom;
		padding.left = insets.left;
		padding.right = insets.right;

	}

	/**
	 * Sets the button's icon to the passed image. 
	 * <p>
	 * <strong>Note:</strong> The old image is disposed. 
	 * So you must not give shared images to this method.
	 */
	@Override
	public void setIcon(Image image) {
		Image oldIcon = getIcon();
		super.setIcon(image);
		if (oldIcon != null) {
			oldIcon.dispose();
		}
	}

	public int getDefaultWidth() {
		return -1;
	}

	public int getDefaultHeight() {
		return -1;
	}

}
