package net.sf.amateras.air.mxml.figures;

import java.util.List;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;

/**
 * DataGrid Figure.
 * 
 * @author HidekoOgawa
 */
public class DataGrid extends AbstractFigure {

	private static final int DEFAULT_HEIGHT = 120;
	private static final int DEFAULT_WIDTH = 300;

	public DataGrid() {
		super();
		setOpaque(true);

		setLayoutManager(new ToolbarLayout(true));
		setBorder(new LineBorder(ColorConstants.lightGray));
	}

	public int getDefaultWidth() {
		if (getChildren().size() == 0) {
			return DEFAULT_WIDTH;
		} else {
			int sum = 0;

			@SuppressWarnings("unchecked")
			List<IFigure> children = getChildren();
			for (IFigure f : children) {
				sum += f.getPreferredSize().width;
			}
			return sum;
		}
	}

	public int getDefaultHeight() {
		return DEFAULT_HEIGHT;
	}

}
