package net.sf.amateras.air.mxml.figures.layouts;

import net.sf.amateras.air.mxml.figures.ContainerFigure;
import net.sf.amateras.air.mxml.figures.IFlexRectangleFigure;
import net.sf.amateras.air.mxml.models.FlexRectangle;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;

public class SizeLibrary {

	private static final int PERCENT_100 = 100;

	private SizeLibrary() {
	}

	/**
	 * figure use size.
	 * @param figure
	 * @param wHint
	 * @param hHint
	 * @return
	 */
	public static Dimension getUseSize(IFigure figure, int wHint, int hHint) {
		Dimension realSize = null;
		Dimension calcSize = getCalculateUseSize(figure, wHint, hHint);
		if (calcSize.width == -1) {
			realSize = getRealSize(figure, wHint, hHint);
			calcSize.width = realSize.width;
		}
		if (calcSize.height == -1) {
			if (realSize == null) {
				realSize = getRealSize(figure, wHint, hHint);
			}
			calcSize.height = realSize.height;
		}
		return calcSize;
	}

	/**
	 * figure use size calculate.
	 * @param figure
	 * @param wHint
	 * @param hHint
	 * @return
	 */
	private static Dimension getCalculateUseSize(IFigure figure, int wHint, int hHint) {
		int width = -1;
		int height = -1;
		Dimension defaultSize = null;

		if (figure instanceof IFlexRectangleFigure) {
			FlexRectangle rec = ((IFlexRectangleFigure) figure).getRectangle();
			if (rec == null) {
				//System.err.println("rectangle is null -" + figure);
				rec = new FlexRectangle();
				((IFlexRectangleFigure) figure).setRectangle(rec);
			}
			width = rec.width;
			height = rec.height;

			if (width == -1) {
				if (rec.getStrWidth().length() == 0) {
					defaultSize = getDefaultSize(figure, wHint, hHint);
					width = defaultSize.width;

				} else if (!(rec.getStrWidth().endsWith("%"))) {
					width = Integer.parseInt(rec.getStrWidth());

				} else {
					//percent.
					int percent = Integer.parseInt(rec.getStrWidth().substring(0, rec.getStrWidth().length() - 1));
					width = getParentRealWidth(figure, wHint, PERCENT_100);
					if (width <= 0 && wHint > 0) {
						width = wHint;
					}

					if (width > 0) {
						width = width * percent / PERCENT_100;
					}
				}
			}

			if (height == -1) {
				if (rec.getStrHeight().length() == 0) {
					if (defaultSize == null) {
						defaultSize = getDefaultSize(figure, wHint, hHint);
					}
					height = defaultSize.height;

				} else if (!(rec.getStrHeight().endsWith("%"))) {
					height = Integer.parseInt(rec.getStrHeight());

				} else {
					//percent.
					int percent = Integer.parseInt(rec.getStrHeight().substring(0, rec.getStrHeight().length() - 1));
					height = getParentRealHeight(figure, hHint, PERCENT_100);
					if (height <= 0 && hHint > 0) {
						height = hHint;
					}

					if (height > 0) {
						height = height * percent / PERCENT_100;
					}
				}
			}
		}
		return new Dimension(width, height);
	}

	private static int getParentRealWidth(IFigure figure, int wHint, int percent) {
		if (figure.getParent() == null) {
			return -1;
		} else {
			if (figure.getParent() instanceof IFlexRectangleFigure) {
				FlexRectangle rec = ((IFlexRectangleFigure) figure.getParent()).getRectangle();
				if (rec.width != -1) {
					return rec.width * percent / PERCENT_100;

				} else if (rec.getStrWidth().length() != 0) {
					if (rec.getStrWidth().endsWith("%")) {
						percent = percent
								* Integer.parseInt(rec.getStrWidth().substring(0, rec.getStrWidth().length() - 1))
								/ PERCENT_100;
						return getParentRealWidth(figure.getParent(), wHint, percent);

					} else {
						return Integer.parseInt(rec.getStrWidth()) * percent / PERCENT_100;
					}
				}
			}
			return -1;
		}
	}

	private static int getParentRealHeight(IFigure figure, int hHint, int percent) {
		if (figure.getParent() == null) {
			return -1;
		} else {
			if (figure.getParent() instanceof IFlexRectangleFigure) {
				FlexRectangle rec = ((IFlexRectangleFigure) figure.getParent()).getRectangle();
				if (rec.height != -1) {
					return rec.height * percent / PERCENT_100;

				} else if (rec.getStrHeight().length() != 0) {
					if (rec.getStrHeight().endsWith("%")) {
						percent = percent
								* Integer.parseInt(rec.getStrHeight().substring(0, rec.getStrHeight().length() - 1))
								/ PERCENT_100;
						return getParentRealHeight(figure.getParent(), hHint, percent);

					} else {
						return Integer.parseInt(rec.getStrHeight()) * percent / PERCENT_100;
					}
				}
			}
			return -1;
		}
	}

	private static Dimension getDefaultSize(IFigure figure, int wHint, int hHint) {
		if (figure instanceof Label) {
			return figure.getPreferredSize(wHint, hHint);

		} else if (figure instanceof IFlexRectangleFigure) {
			int width = ((IFlexRectangleFigure) figure).getDefaultWidth();
			int height = ((IFlexRectangleFigure) figure).getDefaultHeight();
			return new Dimension(width, height);

		} else {
			return new Dimension(10, 10);
		}
	}

	/**
	 * 
	 * @param figure
	 * @param wHint
	 * @param hHint
	 * @return
	 */
	private static Dimension getRealSize(IFigure figure, int wHint, int hHint) {
		if (figure instanceof Label) {
			return figure.getPreferredSize(wHint, hHint);

		} else if (figure instanceof IFlexRectangleFigure && !(figure instanceof ContainerFigure)) {
			int width = ((IFlexRectangleFigure) figure).getDefaultWidth();
			int height = ((IFlexRectangleFigure) figure).getDefaultHeight();
			return new Dimension(width, height);

		} else if (figure.getLayoutManager() instanceof XYLayout) {
			return getChildrenRealSize4XYLayout(figure);

		} else if (figure.getLayoutManager() instanceof ToolbarLayout) {
			return getChildrenRealSize4ToolbarLayout(figure, wHint, hHint);

		} else {
			//System.err.println("Unnone Layouter:" + figure);
			return getChildrenRealSize4XYLayout(figure);
		}
	}

	private static Dimension getCalculateAndDefaultSize(IFigure figure, int wHint, int hHint) {
		Dimension d = getCalculateUseSize(figure, -1, -1);
		Dimension defaultSize = getRealSize(figure, -1, -1);
		int width = d.width;
		int height = d.height;
		if (width == -1) {
			width = defaultSize.width;
		}
		if (height == -1) {
			height = defaultSize.height;
		}
		return new Dimension(width, height);
	}

	private static Dimension getChildrenRealSize4XYLayout(IFigure figure) {
		int width = 0;
		int height = 0;

		for (int i = 0; i < figure.getChildren().size(); i++) {
			IFigure child = (IFigure) figure.getChildren().get(i);

			Dimension d = getCalculateAndDefaultSize(child, -1, -1);
			int subWidth = d.width;
			int subHeight = d.height;

			if (child instanceof IFlexRectangleFigure) {
				FlexRectangle rec = ((IFlexRectangleFigure) child).getRectangle();
				if (rec.x > 0) {
					subWidth += rec.x;
				}
				if (rec.y > 0) {
					subHeight += rec.y;
				}
			} else {
				//System.err.println("No FlexRectangle:" + child);
				Rectangle rec = child.getBounds();
				if (rec.x > 0) {
					subWidth += rec.x;
				}
				if (rec.y > 0) {
					subHeight += rec.y;
				}
			}

			if (width < subWidth) {
				width = subWidth;
			}
			if (height < subHeight) {
				height = subHeight;
			}
		}
		return new Dimension(width, height);
	}

	private static Dimension getChildrenRealSize4ToolbarLayout(IFigure figure, int wHint, int hHint) {
		int width = 0;
		int height = 0;

		boolean isHorizontal = ((ToolbarLayout) figure.getLayoutManager()).isHorizontal();
		Insets insets = figure.getInsets();
		if (isHorizontal) {
			wHint = -1;
			if (hHint >= 0) {
				hHint = Math.max(0, hHint - insets.getHeight());
			}
		} else {
			hHint = -1;
			if (wHint >= 0) {
				wHint = Math.max(0, wHint - insets.getWidth());
			}
		}

		for (int i = 0; i < figure.getChildren().size(); i++) {
			IFigure child = (IFigure) figure.getChildren().get(i);
			Dimension d = getCalculateAndDefaultSize(child, wHint, wHint);

			if (isHorizontal) {
				if (d.width != -1) {
					width += d.width;
				}
				if (d.height != -1) {
					if (height < d.height) {
						height = d.height;
					}
				}

			} else {
				if (d.height != -1) {
					height += d.height;
				}
				if (d.width != -1) {
					if (width < d.width) {
						width = d.width;
					}
				}
			}
		}

		if (wHint >= 0 && width > wHint) {
			width = wHint;

		} else if (hHint >= 0 && height > hHint) {
			height = hHint;
		}

		int spacing = ((ToolbarLayout) figure.getLayoutManager()).getSpacing();
		if (isHorizontal) {
			width += Math.max(0, figure.getChildren().size() - 1) * spacing;
		} else {
			height += Math.max(0, figure.getChildren().size() - 1) * spacing;
		}

		Transposer transposer = new Transposer();
		//transposer.setEnabled(isHorizontal);
		Dimension d2 = transposer.t(new Dimension(width, height)).expand(insets.getWidth(), insets.getHeight()).union(
				getBorderPreferredSize(figure));

		return d2;
	}

	private static Dimension getBorderPreferredSize(IFigure container) {
		if (container.getBorder() == null) {
			return new Dimension();
		}
		return container.getBorder().getPreferredSize(container);
	}
}
