package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.containers.DividedBox.
 * 
 * @author ogawahideko
 *
 */
public class DividedBoxModel extends BoxModel {
	private static final double DIVIDER_ALPHA_DEFAULT_VALUE = 0.75;

	public static final String COMPONENT_NAME = "DividedBox";

	public static final String LIVE_DRAGGING = "liveDragging";
	public static final String RESIZE_TO_CONTENT = "resizeToContent";

	public static final String DIVIDER_AFFORDANCE = "dividerAffordance";
	public static final String DIVIDER_ALPHA = "dividerAlpha";
	public static final String DIVIDER_COLOR = "dividerColor";
	public static final String DIVIDER_SKIN = "dividerSkin";
	public static final String DIVIDER_THICKNESS = "dividerThickness";
	public static final String HORIZONTAL_DIVIDER_COURSOR = "horizontalDividerCursor";
	public static final String VERTICAL_DIVIDER_COURSOR = "verticalDividerCursor";

	public static final String DIVIDER_PRESS = "dividerPress";
	public static final String DIVIDER_DRAG = "dividerDrag";
	public static final String DIVIDER_RELEASE = "dividerRelease";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addBooleanModelProperty(LIVE_DRAGGING, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(RESIZE_TO_CONTENT, CATEGORY_PROPERTY, false);

		addNumberModelProperty(DIVIDER_AFFORDANCE, CATEGORY_STYLE, 6);
		addDoubleModelProperty(DIVIDER_ALPHA, CATEGORY_STYLE, DIVIDER_ALPHA_DEFAULT_VALUE);
		addColorModelProperty(DIVIDER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#6F7777"));
		addStringModelProperty(DIVIDER_SKIN, CATEGORY_STYLE, "BoxDividerSkin");
		addNumberModelProperty(DIVIDER_THICKNESS, CATEGORY_STYLE, 3);
		addStringModelProperty(HORIZONTAL_DIVIDER_COURSOR, CATEGORY_STYLE, "mx.skins.cursor.HBoxDivider");
		addStringModelProperty(VERTICAL_DIVIDER_COURSOR, CATEGORY_STYLE, "mx.skins.cursor.VBoxDivider");

		addStringModelProperty(DIVIDER_PRESS, CATEGORY_EVENT);
		addStringModelProperty(DIVIDER_DRAG, CATEGORY_EVENT);
		addStringModelProperty(DIVIDER_RELEASE, CATEGORY_EVENT);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

}
