package net.sf.amateras.air.mxml.models;

/**
 * Model of mx.controls.FileSystemTree
 * 
 * @author ogawahideko
 *
 */
public class FileSystemTreeModel extends TreeModel {
	public static final String PACKAGE_NAME = "mx.controls";
	public static final String COMPONENT_NAME = "FileSystemTree";

	public static final String DIRECTORY = "directory";
	public static final String ENUMERATION_MODE = "enumerationMode";
	public static final String EXTENSIONS = "extensions";
	public static final String FILTER_FUNCTION = "filterFunction";
	public static final String NAME_COMPARE_FUNCTION = "nameCompareFunction";
	public static final String OPEN_PATHS = "openPaths";
	public static final String SELECTED_PATH = "selectedPath";
	public static final String SELECTED_PATHS = "selectedPaths";
	public static final String SHOW_EXTENSIONS = "showExtensions";
	public static final String SHOW_HIDDEN = "showHidden";
	public static final String SHOW_ICONS = "showIcons";

	public static final String DIRECTORY_CHANGE = "directoryChange";
	public static final String DIRECTORY_CLOSING = "directoryClosing";
	public static final String DIRECTORY_OPENING = "directoryOpening";
	public static final String FILE_CHOOSE = "fileChoose";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(DIRECTORY, CATEGORY_PROPERTY);
		addStringModelProperty(ENUMERATION_MODE, CATEGORY_PROPERTY);
		addStringModelProperty(EXTENSIONS, CATEGORY_PROPERTY);
		addStringModelProperty(FILTER_FUNCTION, CATEGORY_PROPERTY);
		addStringModelProperty(NAME_COMPARE_FUNCTION, CATEGORY_PROPERTY);
		addStringModelProperty(OPEN_PATHS, CATEGORY_PROPERTY);
		addStringModelProperty(SELECTED_PATH, CATEGORY_PROPERTY);
		addStringModelProperty(SELECTED_PATHS, CATEGORY_PROPERTY);
		addBooleanModelProperty(SHOW_EXTENSIONS, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(SHOW_HIDDEN, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(SHOW_ICONS, CATEGORY_PROPERTY, true);

		addStringModelProperty(DIRECTORY_CHANGE, CATEGORY_EVENT);
		addStringModelProperty(DIRECTORY_CLOSING, CATEGORY_EVENT);
		addStringModelProperty(DIRECTORY_OPENING, CATEGORY_EVENT);
		addStringModelProperty(FILE_CHOOSE, CATEGORY_EVENT);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}
}
