package net.sf.amateras.air.templates;

import java.util.StringTokenizer;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;

/**
 * TemplateContext for ActionScript
 * @author ogawahideko
 *
 */
public class ActionScriptTemplateContext extends DocumentTemplateContext {
	public ActionScriptTemplateContext(TemplateContextType type, IDocument document, int offset, int length) {
		super(type, document, offset, length);
	}

	@Override
	public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
		return super.evaluate(correctIndention(template, getDocument(), getStart()));
	}

	public static Template correctIndention(Template template, IDocument d, int offset) {
		if (offset == -1 || d.getLength() == 0) {
			return template;
		}
		String pattern = template.getPattern();
		String delim = d.getLegalLineDelimiters()[0];
		StringBuffer buf = new StringBuffer();

		for (String nl : d.getLegalLineDelimiters()) {
			if (nl.equals("\n")) {
				delim = nl;
			}
		}
		if (pattern.indexOf('\n') < 0 && pattern.indexOf('\r') < 0) {
			return template;
		}
		try {
			int p = offset == d.getLength() ? offset - 1 : offset;
			IRegion info = d.getLineInformationOfOffset(p);
			int start = info.getOffset();
			// find white spaces
			int end = findEndOfWhiteSpace(d, start, offset);
			buf = new StringBuffer(delim);
			if (end > start) {
				// append to input
				buf.append(d.get(start, end - start));
			}
			String indent = buf.toString();
			buf = new StringBuffer();
			StringTokenizer tokenizer = new StringTokenizer(pattern, "\r\n\t", true);
			char lastnl = 0;
			while (tokenizer.hasMoreTokens()) {
				String token = tokenizer.nextToken();
				char c = token.charAt(0);
				if (c == '\n' || c == '\r') {
					if (lastnl == 0 || lastnl == c) {
						buf.append(indent);
					}
					lastnl = c;
					continue;
				}
				lastnl = 0;
				buf.append(token);
			}
			return new Template(template.getName(), template.getDescription(), template.getContextTypeId(), buf
					.toString(), template.isAutoInsertable());
		} catch (BadLocationException e) {
			AIRPlugin.logException(e);
		}
		return template;
	}

	private static int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
		while (offset < end) {
			char c = document.getChar(offset);
			if (c != ' ' && c != '\t') {
				return offset;
			}
			offset++;
		}
		return end;
	}
}
