package net.sf.amateras.air.templates;

import org.eclipse.jface.text.templates.TemplateContextType;

/**
 * ContextType for ApplicationDescriptor XML
 * @author ogawahideko
 *
 */
public class DescriptorContextType extends TemplateContextType {
	public static final String APPLICATION_ID = "applicationId";
	public static final String APPLICATION_NAME = "applicationName";
	public static final String DESCRIPTION = "description";
	public static final String COPYRIGHT = "copyright";
	public static final String CONTENT = "content";
	public static final String VISIBLE = "visible";

	public DescriptorContextType() {
		addResolver(new NoResolver(APPLICATION_ID, "AIR ApplicationId"));
		addResolver(new NoResolver(APPLICATION_NAME, "AIR ApplicationName"));
		addResolver(new NoResolver(DESCRIPTION, "AIR Description"));
		addResolver(new NoResolver(COPYRIGHT, "AIR CopyRight"));
		addResolver(new NoResolver(CONTENT, "AIR initialWindow/content"));
		addResolver(new NoResolver(VISIBLE, "AIR initialWindow/visible"));
	}

}
