package net.sf.amateras.air.util;

import java.io.File;
import java.io.IOException;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.natures.AIRFlexProjectNature;
import net.sf.amateras.air.natures.AIRHTMLProjectNature;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * Process create Library.
 * @author Hideko Ogawa
 *
 */
public class ProcessUtil {

	private ProcessUtil() {
	}

	/**
	 * create process
	 * @param executeFile execute command file
	 * @param currentDir execute current directory
	 * @return
	 * @throws IOException
	 */
	public static Process createProcess(File executeFile, File currentDir) throws IOException {
		String executePath = executeFile.getAbsolutePath();
		System.out.println(executePath);
		return Runtime.getRuntime().exec(executePath, null, currentDir);
	}

	/**
	 * create process
	 * @param executeFile execute command file
	 * @param commands command option
	 * @param currentDir execute current directory
	 * @return
	 * @throws IOException
	 */
	public static Process createProcess(File executeFile, String[] commands, File currentDir) throws IOException {
		String executePath = executeFile.getAbsolutePath();
		//		if (executePath.indexOf(" ") > 0) {
		//			executePath = "\"" + executePath + "\" ";
		//		}

		String[] newCommand = new String[commands.length + 1];
		newCommand[0] = executePath;
		for (int i = 1; i < commands.length + 1; i++) {
			newCommand[i] = commands[i - 1];
		}
		return Runtime.getRuntime().exec(newCommand, null, currentDir);
	}

	public static boolean checkAirGearProject(IProject project) {
		boolean isNotAirGearProject = false;
		try {
			if (!project.hasNature(AIRHTMLProjectNature.NATURE_ID)
					&& !project.hasNature(AIRFlexProjectNature.NATURE_ID)) {
				isNotAirGearProject = true;
			}
		} catch (CoreException e) {
			isNotAirGearProject = true;
		}

		if (isNotAirGearProject) {
			UIUtil.openErrorDialog(AIRPlugin.getResourceString("NOT_AIRGEAR_PROJECT"));
			return false;
		} else {
			return true;
		}
	}

	public static String getAirSdkPath() {
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		String sdkPath = store.getString(AIRPlugin.PREF_FLEX_SDK_PATH);
		if (sdkPath.length() == 0) {
			sdkPath = store.getString(AIRPlugin.PREF_AIR_SDK_PATH);
			if (sdkPath.length() == 0) {
				return null;
			}
		}
		return sdkPath;
	}

	public static String getAirSdkPath(String needfilePath) {
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		String flexSdkPath = store.getString(AIRPlugin.PREF_FLEX_SDK_PATH);
		String airSdkPath = store.getString(AIRPlugin.PREF_AIR_SDK_PATH);

		if (flexSdkPath.length() != 0) {
			File adl = new File(flexSdkPath, needfilePath);
			if (adl.exists()) {
				return flexSdkPath;
			}
		}

		if (airSdkPath.length() != 0) {
			File adl = new File(airSdkPath, needfilePath);
			if (adl.exists()) {
				return airSdkPath;
			}
		}

		UIUtil.openErrorDialog(AIRPlugin.getResourceString("NOT_SDK_SETTING"));
		DebugPlugin.logMessage(AIRPlugin.getResourceString("NOT_SDK_SETTING"), null);
		return null;

	}
}
