package net.sf.amateras.air.util;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import net.sf.amateras.air.AIRPlugin;

import org.apache.commons.jxpath.JXPathContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/**
 * 
 * @author Naoki Takezoe
 */
public class XMLUtil {

	private XMLUtil() {
	}

	public static final String DESCRIPTOR_NS = "http://ns.adobe.com/air/application/1.0";
	public static final String MXML_NS = "http://www.adobe.com/2006/mxml";

	public static String escape(String text) {
		text = text.replaceAll("&", "&amp;");
		text = text.replaceAll("<", "&lt;");
		text = text.replaceAll(">", "&gt;");
		text = text.replaceAll("\"", "&quot;");
		return text;
	}

	public static Map<String, String> createNsMap() {
		Map<String, String> map = new HashMap<String, String>();
		map.put("a", DESCRIPTOR_NS);
		map.put("mx", MXML_NS);
		return map;
	}

	public static String getMainFile(IProject project) throws Exception {
		ScopedPreferenceStore projectStore = new ScopedPreferenceStore(new ProjectScope(project), AIRPlugin.PLUGIN_ID);
		String descriptor = projectStore.getString(AIRPlugin.PREF_DESCRIPTOR);
		IFile targetFile = project.getFile(new Path(descriptor));

		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		Document doc = builder.parse(targetFile.getContents());

		Node[] nodes = evalXPath(doc, createNsMap(), "a:application/a:initialWindow/a:content/text()");
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < nodes.length; i++) {
			Text text = (Text) nodes[i];
			sb.append(text.getNodeValue());
		}

		return sb.toString().trim();
	}

	/**
	 * get include ASFiles from mxmlFiles
	 * @param mainFile
	 * @param asFile
	 * @return
	 */
	public static Map<String, IFile> getIncludeASFiles(IFile mainFile, Map<String, IFile> appendList) {

		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document doc = builder.parse(mainFile.getContents());

			String path = "//" + AIRPlugin.getDefault().getNameSpacePrefix() + "Script/@source";
			Node[] nodes = evalXPath(doc, null, path);
			for (int i = 0; i < nodes.length; i++) {

				if (nodes[i].getNodeType() == Node.ATTRIBUTE_NODE) {
					String text = nodes[i].getNodeValue();
					appendList.put(text, mainFile);
				}
			}

		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return appendList;
	}

	@SuppressWarnings("unchecked")
	public static Node[] evalXPath(Node node, Map nsMap, String xpath) {
		try {
			JXPathContext ctx = JXPathContext.newContext(node);
			if (nsMap != null) {
				Object[] entries = nsMap.entrySet().toArray();
				for (int i = 0; i < entries.length; i++) {
					Map.Entry entry = (Map.Entry) entries[i];
					ctx.registerNamespace((String) entry.getKey(), (String) entry.getValue());
				}
			}
			List nodes = ctx.selectNodes(xpath);
			return (Node[]) nodes.toArray(new Node[nodes.size()]);

		} catch (Exception ex) {
			return new Node[0];
		}
	}

	public static String nodeToXML(Node node) {

		StringWriter writer = new StringWriter();

		try {
			Transformer transformer = TransformerFactory.newInstance().newTransformer();
			transformer.transform(new DOMSource(node), new StreamResult(writer));

			String value = writer.toString();
			value = value.substring(value.indexOf("?>") + 2);
			return value;
		} catch (Exception ex) {
			ex.printStackTrace();
			return node.toString();
		}

	}

	//	public static Node[] evalXPath(Node node, String xpath) {
	//		return evalXPath(node, Collections.EMPTY_MAP, xpath);
	//	}

}
