package net.sf.amateras.air.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.util.Map;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.natures.AIRHTMLProjectNature;
import net.sf.amateras.air.templates.DescriptorContextType;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * 
 * @author Naoki Takezoe
 */
public class NewAIRHTMLProjectWizard extends AbstractNewAIRProjectWizard {

	public NewAIRHTMLProjectWizard() {
		setWindowTitle("New AIR HTML Project");
	}

	@Override
	protected void addProjectSpecificParameters(Map<String, String> params) {
		String mainHTML = ((AIRHTMLProjectPropertiesWizardPage) page2).getMainHTML();
		params.put(DescriptorContextType.CONTENT, mainHTML);
	}

	@Override
	protected AIRProjectWizardPage createPage1() {
		AIRProjectWizardPage page = new AIRProjectWizardPage("New HTML AIR Application Project",
				AIRProjectWizardPage.HTML_PROJECT);
		page.setTitle("New HTML AIR Application Project");
		page.setDescription("Create new HTML based AIR application project.");
		return page;
	}

	@Override
	protected AbstractAIRProjectPropertiesWizardPage createPage2() {
		AIRHTMLProjectPropertiesWizardPage page = new AIRHTMLProjectPropertiesWizardPage("HTML Project Properties");
		page.setTitle("HTML Project Properties");
		page.setDescription("Input your project properties.");
		return page;
	}

	@Override
	protected void createProjectSpecificResources(IProject project, String descriptorTemplateName,
			Map<String, String> params, IProgressMonitor monitor) throws Exception {
		// make application descriptor
		createFile(project, "application.xml", getTemplateContents(descriptorTemplateName), params, monitor);

		// make main html
		createFile(project, params.get(DescriptorContextType.CONTENT), NewAIRHTMLProjectWizard.class
				.getResourceAsStream("main.html"), params, monitor);

		// copy JavaScript
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		String sdkPath = store.getString(AIRPlugin.PREF_AIR_SDK_PATH);
		File javaScript = new File(sdkPath, "frameworks/AIRAliases.js");
		createFile(project, "AIRAliases.js", new FileInputStream(javaScript), null, monitor);
	}

	@Override
	protected String getNatureId() {
		return AIRHTMLProjectNature.NATURE_ID;
	}

}
