package net.sf.amateras.air.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

/**
 * abstract editor action for AIR GEAR.
 * Clients may neither instantiate nor extend this class.
 * 
 * @author hideko ogawa
 */
public abstract class AbstractAirEditorAction extends Action implements IEditorActionDelegate {
	protected volatile IEditorPart targetEditor;
	protected ISelection selection;

	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		this.targetEditor = targetEditor;
	}

	public void selectionChanged(IAction action, ISelection selection) {
		action.setEnabled(true);
		this.selection = selection;
	}

	public IEditorPart getActiviEditor() {
		return targetEditor;
	}

	protected ITextEditor getTextEditor() {
		if (targetEditor instanceof ITextEditor) {
			return (ITextEditor) targetEditor;
		} else {
			throw new RuntimeException("Expecting text editor. Found:" + targetEditor.getClass().getName());
		}
	}
}
