package net.sf.amateras.air.as.syntax.analyze;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.as.syntax.ISyntaxClass;
import net.sf.amateras.air.as.syntax.PreviousWord;
import net.sf.amateras.air.as.syntax.proposal.DefaultCompletionProposal;

import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class TopLevelAnalizer {
	private static List<DefaultCompletionProposal> topLevel;

	public void addSyntaxClass(int documentOffset, PreviousWord previousWord, List<ICompletionProposal> proposals) {
		if (previousWord.getPreviousWord().length() == 0) {
			return;
		}
		if (previousWord.getType() != PreviousWord.TYPE_ALL && previousWord.getType() != PreviousWord.TYPE_CLASS
				&& previousWord.getType() != PreviousWord.TYPE_CLASS_NEW) {
			return;
		}

		if (topLevel == null) {
			loadTopLevel();
		}
		for (int i = 0; i < topLevel.size(); i++) {
			DefaultCompletionProposal proposal = topLevel.get(i);
			if (previousWord.getType() == PreviousWord.TYPE_CLASS && proposal.getType() != ISyntaxClass.TYPE_CLASS) {
				continue;
			}
			if (previousWord.getType() == PreviousWord.TYPE_CLASS_NEW
					&& proposal.getType() != ISyntaxClass.TYPE_FUNCTION) {
				continue;
			}
			if (proposal.getReplacementString().toLowerCase().startsWith(previousWord.getPreviousWord().toLowerCase())) {
				proposal.setReplacementLength(previousWord.getPreviousWord().length());
				proposal.setReplacementOffset(documentOffset - previousWord.getPreviousWord().length());
				proposals.add(proposal);
			}
		}
	}

	private void loadTopLevel() {
		topLevel = new ArrayList<DefaultCompletionProposal>();
		String[] array = readStreamToStringArray();
		for (String s : array) {
			String typeName = s.substring(0, s.indexOf(" "));
			String method = s.substring(s.indexOf(" ") + 1);
			DefaultCompletionProposal syntax = null;

			if (typeName.equals("function")) {
				syntax = createFunctionProperty(method);

			} else if (typeName.equals("const")) {
				syntax = createConstantProperty(method);

			} else if (typeName.equals("property")) {
				syntax = createConstantProperty(method);

			} else if (typeName.equals("class")) {
				syntax = createClass(method);

			}
			topLevel.add(syntax);
		}
	}

	/**
	 * parse function info, and syntax setting.
	 * @param information
	 * @param syntax
	 */
	private DefaultCompletionProposal createFunctionProperty(String information) {
		char[] array = information.toCharArray();
		StringBuilder methodName = new StringBuilder();
		StringBuilder argInfo = null;
		StringBuilder returnInfo = null;
		for (char c : array) {
			if (c == '(') {
				if (argInfo == null) {
					argInfo = new StringBuilder();
					continue;
				}
			}
			if (c == ')') {
				if (returnInfo == null) {
					returnInfo = new StringBuilder();
					continue;
				}
			}

			if (returnInfo != null) {
				returnInfo.append(c);
			} else if (argInfo != null) {
				argInfo.append(c);
			} else {
				methodName.append(c);
			}
		}

		DefaultCompletionProposal proposal = new DefaultCompletionProposal(ISyntaxClass.TYPE_FUNCTION, methodName
				.toString()
				+ "()");

		proposal.setCursorPosition(methodName.length() + 1);
		proposal.setDisplayString(information);
		proposal.setAdditionalProposalInfo(argInfo.toString());
		proposal.setContextInformation(new ContextInformation(information, argInfo.toString()));
		return proposal;
	}

	private DefaultCompletionProposal createConstantProperty(String information) {
		String methodName = information.substring(0, information.indexOf(":"));
		DefaultCompletionProposal proposal = new DefaultCompletionProposal(ISyntaxClass.TYPE_CONSTANT, methodName
				.toString());
		proposal.setCursorPosition(methodName.length());
		proposal.setDisplayString(information);
		proposal.setAdditionalProposalInfo(information);
		proposal.setContextInformation(new ContextInformation(information, information));

		return proposal;
	}

	private DefaultCompletionProposal createClass(String information) {
		String methodName = information;
		DefaultCompletionProposal proposal = new DefaultCompletionProposal(ISyntaxClass.TYPE_CLASS, methodName
				.toString());
		proposal.setCursorPosition(methodName.length());
		proposal.setDisplayString(information);
		proposal.setAdditionalProposalInfo(information);
		proposal.setContextInformation(new ContextInformation(information, information));

		return proposal;
	}

	/**
	 * read file, return StringArray.
	 * @param filePath
	 * @return
	 */
	private String[] readStreamToStringArray() {
		BufferedReader bReader = null;
		InputStream input = null;

		try {
			input = getClass().getResourceAsStream("/syntax/TopLevel");
			bReader = new BufferedReader(new InputStreamReader(input));
			String line;
			ArrayList<String> list = new ArrayList<String>();

			while ((line = bReader.readLine()) != null) {
				if (line.length() == 0) {
					continue;
				}
				list.add(line);
			}
			return list.toArray(new String[list.size()]);

		} catch (IOException e) {
			e.printStackTrace();
			return null;
		} finally {
			try {
				if (bReader != null) {
					bReader.close();
				}
				if (input != null) {
					input.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

}
