package net.sf.amateras.air.as.syntax.proposal;

import net.sf.amateras.air.as.syntax.SyntaxReader;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class DefaultCompletionProposal implements ICompletionProposal {

	private String fDisplayString;
	private String fReplacementString;
	private int fReplacementOffset;
	private int fReplacementLength;
	private int fCursorPosition;
	private IContextInformation fContextInformation;
	private String fAdditionalProposalInfo;
	private int fType;
	private Image image;

	public DefaultCompletionProposal(int type, String replacementString) {
		Assert.isNotNull(replacementString);

		fReplacementString = replacementString;
		fType = type;
	}

	public void setReplacementLength(int replacementLength) {
		fReplacementLength = replacementLength;
	}

	public void setReplacementOffset(int replacementOffset) {
		fReplacementOffset = replacementOffset;
	}

	public void setCursorPosition(int cursorPosition) {
		fCursorPosition = cursorPosition;
	}

	public void setDisplayString(String displayString) {
		fDisplayString = displayString;
	}

	public void setContextInformation(IContextInformation contextInformation) {
		fContextInformation = contextInformation;
	}

	public void setAdditionalProposalInfo(String additionalProposalInfo) {
		fAdditionalProposalInfo = additionalProposalInfo;
	}

	public int getCursorPosition() {
		return fCursorPosition;
	}

	public void setImage(Image image) {
		this.image = image;
	}

	public void apply(IDocument document) {
		try {
			document.replace(fReplacementOffset, fReplacementLength, fReplacementString);

		} catch (BadLocationException x) {
			// ignore
		}
	}

	/*
	 * @see ICompletionProposal#getSelection(IDocument)
	 */
	public Point getSelection(IDocument document) {
		return new Point(fReplacementOffset + fCursorPosition, 0);
	}

	/*
	 * @see ICompletionProposal#getContextInformation()
	 */
	public IContextInformation getContextInformation() {
		return fContextInformation;
	}

	/*
	 * @see ICompletionProposal#getImage()
	 */
	public Image getImage() {
		return image != null ? image : SyntaxReader.getTypeImage(fType);
	}

	/*
	 * @see ICompletionProposal#getDisplayString()
	 */
	public String getDisplayString() {
		return fDisplayString != null ? fDisplayString : fReplacementString;
	}

	/*
	 * @see ICompletionProposal#getAdditionalProposalInfo()
	 */
	public String getAdditionalProposalInfo() {
		return fAdditionalProposalInfo;
	}

	public String getReplacementString() {
		return fReplacementString;
	}

	public int getType() {
		return fType;
	}
}
