package net.sf.amateras.air.as.syntax.proposal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ImportCompletionProposal extends DefaultCompletionProposal {

	private String fPackageName;

	public ImportCompletionProposal(int type, String replacementString, String packageName) {
		super(type, replacementString);
		fPackageName = packageName;
	}

	@Override
	public void apply(IDocument document) {
		try {
			super.apply(document);
			if (fPackageName == null || fPackageName.length() == 0) {
				return;
			}
			String text = document.get();
			// add import statement.
			String addValue = "import " + fPackageName + "." + getReplacementString() + ";";
			Pattern valuePattern = Pattern.compile(addValue);
			if (valuePattern.matcher(text).find()) {
				// already exists.
				return;
			}

			Object[] objects = getEndOfImportPosition(text);
			int offset = (Integer) objects[0];
			if (offset < 0) {
				offset = getPackagePosition(text);
			}
			if (offset > 0) {
				addValue = "\n" + objects[1] + addValue;
			}

			document.replace(offset, 0, addValue);
			setCursorPosition(getCursorPosition() + addValue.length());

		} catch (BadLocationException x) {
			// ignore
		}
	}

	private Object[] getEndOfImportPosition(String text) {
		Pattern imports = Pattern.compile("(.*)(import[ ].*)");
		Matcher matcher = imports.matcher(text);
		int position = -1;
		String prefix = "";
		while (matcher.find()) {
			position = matcher.end();
			prefix = matcher.group(1);
		}
		return new Object[] { position, prefix };
	}

	private int getPackagePosition(String text) {
		Pattern packagePattern = Pattern.compile(".*package[ ].*\\{");
		Matcher matcher = packagePattern.matcher(text);
		int position = -1;
		while (matcher.find()) {
			position = matcher.end();
		}
		return position;
	}

}
